/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.common.unit.BinaryPrefix;
import com.jrockit.mc.core.model.fields.NumberField;
import java.text.NumberFormat;

public class FrequencyByteField
extends NumberField {
    private static final NumberFormat FORMATTER = NumberFormat.getInstance();
    private static final String[] SPACED_UNITS;

    static {
        FORMATTER.setMinimumFractionDigits(2);
        FORMATTER.setMaximumFractionDigits(2);
        BinaryPrefix[] prefixes = BinaryPrefix.values();
        SPACED_UNITS = new String[prefixes.length];
        FrequencyByteField.SPACED_UNITS[0] = " bytes/s";
        int i = 1;
        while (i < prefixes.length) {
            FrequencyByteField.SPACED_UNITS[i] = " " + prefixes[i].prefixSI + "B/s";
            ++i;
        }
    }

    public FrequencyByteField(int id) {
        super(id);
    }

    public String formatObject(Object object) {
        Number number;
        if (object instanceof Number && FrequencyByteField.isValid(number = (Number)object)) {
            double value = number.doubleValue();
            BinaryPrefix prefix = BinaryPrefix.getFloorPrefix((double)value);
            return String.valueOf(FORMATTER.format(prefix.convertTo(value))) + SPACED_UNITS[prefix.log1024()];
        }
        return super.formatObject(object);
    }

    public String getUnit() {
        return "bytes/s";
    }

    public String getTooltip(Object object) {
        if (object instanceof Number && FrequencyByteField.isValid((Number)object)) {
            return String.valueOf(FORMATTER.format(((Number)object).doubleValue())) + ' ' + this.getUnit();
        }
        return null;
    }
}

