/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.common.porting.JDK14Util;
import com.jrockit.mc.core.model.fields.IFieldListener;
import com.jrockit.mc.core.model.fields.IFieldUI;
import com.jrockit.mc.core.model.fields.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;

public class Field
implements Cloneable,
IFieldUI {
    public static final String PROPERTY_MINWIDTH = "width";
    public static final String PROPERTY_WIDTHWEIGHT = "widthweight";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_SORTORDER = "sortorder";
    public static final String PROPERTY_NAME = "NAME_TEXT";
    public static final String PROPERTY_DESCRIPTION = "DESCRIPTION_TEXT";
    public static final String PROPERTY_CONTENT_CHANGE = "content.change";
    public static final String PROPERTY_VISIBILITY_CHANGE = "visibility.change";
    public static final String PROPERTY_BOLD = "bold";
    public final int INDEX;
    public String IDENTIFIER = "";
    private Properties m_properties = new Properties();
    private boolean m_modifiable = true;
    private Collection<IFieldListener> m_fieldListeners = Collections.synchronizedCollection(new HashSet());
    private boolean m_changed = false;

    public Field(int id) {
        this.INDEX = id;
    }

    public void addListsner(IFieldListener listener) {
        this.m_fieldListeners.add(listener);
    }

    public synchronized void removeListener(IFieldListener listener) {
        this.m_fieldListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(Object property) {
        Object[] listeners = new Object[]{};
        Collection<IFieldListener> collection = this.m_fieldListeners;
        synchronized (collection) {
            if (this.m_changed) {
                listeners = this.m_fieldListeners.toArray();
            }
            this.m_changed = false;
        }
        int n = 0;
        while (n < listeners.length) {
            IFieldListener f = (IFieldListener)listeners[n];
            f.changed(this, property);
            ++n;
        }
    }

    public void initialize(String identifier) {
        this.IDENTIFIER = identifier;
        this.setMinWidth(80);
        this.setWidthWeight(10);
        this.setVisible(true);
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(this.getFullKey(key));
    }

    public void setProperty(String key, String value) {
        this.setChanged();
        this.m_properties.setProperty(this.getFullKey(key), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChanged() {
        Collection<IFieldListener> collection = this.m_fieldListeners;
        synchronized (collection) {
            this.m_changed = true;
        }
    }

    public String getKeyFromProperty(String fullKey) {
        if (!fullKey.startsWith(String.valueOf(this.IDENTIFIER) + "_")) {
            return null;
        }
        return fullKey.substring((String.valueOf(this.IDENTIFIER) + "_").length());
    }

    public String getName() {
        return this.getString(PROPERTY_NAME, "Unknown name");
    }

    public String getDescription() {
        return this.getString(PROPERTY_DESCRIPTION, "");
    }

    public void setDescription(String description) {
        this.setString(PROPERTY_DESCRIPTION, description);
    }

    public void setModifiable(boolean modifiable) {
        this.m_modifiable = modifiable;
    }

    public boolean isModifiable() {
        return this.m_modifiable;
    }

    public void setName(String name) {
        this.setString(PROPERTY_NAME, name);
    }

    public void setProperties(Properties properties) {
        this.m_properties = properties;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public int getInteger(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Field newInstance() {
        Field field;
        try {
            field = (Field)this.clone();
            field.m_fieldListeners = Collections.synchronizedCollection(new HashSet());
            field.setProperties((Properties)this.m_properties.clone());
        }
        catch (Exception e) {
            return this;
        }
        return field;
    }

    public void setInteger(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public String getFullKey(String key) {
        if (key != null) {
            return String.valueOf(this.IDENTIFIER) + "_" + key;
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            String prop = this.getProperty(key);
            if (prop == null) {
                return defaultValue;
            }
            return JDK14Util.parseBoolean((String)prop);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public void setBoolean(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setString(String key, String value) {
        this.setProperty(key, value);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }

    public void setWidthWeight(int widthWeight) {
        this.setInteger(PROPERTY_WIDTHWEIGHT, widthWeight);
    }

    public int getWidthWeight() {
        return this.getInteger(PROPERTY_WIDTHWEIGHT, 10);
    }

    public void setMinWidth(int width) {
        this.setInteger(PROPERTY_MINWIDTH, width);
    }

    public void setSortOrder(boolean sortOrder) {
        this.setBoolean(PROPERTY_SORTORDER, sortOrder);
    }

    public int getMinWidth() {
        return this.getInteger(PROPERTY_MINWIDTH, 80);
    }

    public void setVisible(boolean visible) {
        this.setBoolean(PROPERTY_VISIBLE, visible);
    }

    public boolean isVisible() {
        return this.getBoolean(PROPERTY_VISIBLE, true);
    }

    public boolean getSortOrderAscending() {
        return this.getBoolean(PROPERTY_SORTORDER, true);
    }

    public String formatObject(Object object) {
        return Field.defaultFormat(object);
    }

    public String getUnit() {
        return null;
    }

    public String getTooltip(Object object) {
        return null;
    }

    public ImageDescriptor getImage(Object object) {
        return null;
    }

    public ImageDescriptor getToolTipImage(Object object) {
        return null;
    }

    public static String defaultFormat(Object object) {
        if (object != null) {
            return object.toString();
        }
        return Messages.Field_N_A;
    }

    public int compare(Object a, Object b, boolean order) {
        if (a instanceof Comparable && b instanceof Comparable) {
            return order ? ((Comparable)a).compareTo((Comparable)b) : ((Comparable)b).compareTo((Comparable)a);
        }
        return order ? Field.defaultFormat(a).compareTo(Field.defaultFormat(b)) : Field.defaultFormat(b).compareTo(Field.defaultFormat(a));
    }

    public void setInput(Object input) {
    }

    protected Object getInput() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChanged() {
        Collection<IFieldListener> collection = this.m_fieldListeners;
        synchronized (collection) {
            return this.m_changed;
        }
    }

    public void dispose() {
        this.m_fieldListeners.clear();
    }
}

