/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.model.fields;

import com.jrockit.mc.core.model.fields.NumberField;
import java.text.NumberFormat;

public class ByteField
extends NumberField {
    public static final long BYTE = 1L;
    public static final long KILO_BYTE = 1024L;
    public static final long MEGA_BYTE = 0x100000L;
    public static final long GIGA_BYTE = 0x40000000L;
    private static final NumberFormat FRACTION_FORMATTER = NumberFormat.getInstance();
    private static final NumberFormat INTEGER_FORMATTER;

    static {
        FRACTION_FORMATTER.setMinimumFractionDigits(2);
        FRACTION_FORMATTER.setMaximumFractionDigits(2);
        INTEGER_FORMATTER = NumberFormat.getInstance();
        INTEGER_FORMATTER.setMinimumFractionDigits(0);
        INTEGER_FORMATTER.setMaximumFractionDigits(0);
    }

    public ByteField(int id) {
        super(id);
    }

    public String formatObject(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            if (!ByteField.isValid(number)) {
                return super.formatObject(null);
            }
            long bytes = number.longValue();
            long absBytes = Math.abs(bytes);
            if (absBytes < 1024L) {
                if (absBytes == 1L) {
                    return String.valueOf(INTEGER_FORMATTER.format(bytes)) + this.getSingleUnit();
                }
                return String.valueOf(INTEGER_FORMATTER.format(bytes)) + ' ' + this.getUnit();
            }
            if (absBytes < 0x100000L) {
                return String.valueOf(FRACTION_FORMATTER.format((double)bytes / 1024.0)) + this.getTimeUnit(" kB");
            }
            if (absBytes < 0x40000000L) {
                return String.valueOf(FRACTION_FORMATTER.format((double)bytes / 1048576.0)) + this.getTimeUnit(" MB");
            }
            return String.valueOf(FRACTION_FORMATTER.format((double)bytes / 1.073741824E9)) + this.getTimeUnit(" GB");
        }
        return super.formatObject(object);
    }

    private String getSingleUnit() {
        return this.getTimeUnit(" byte");
    }

    public String getUnit() {
        return this.getTimeUnit("bytes");
    }

    public String getTooltip(Object object) {
        if (object instanceof Number && ByteField.isValid((Number)object)) {
            return String.valueOf(INTEGER_FORMATTER.format(((Number)object).longValue())) + ' ' + this.getUnit();
        }
        return null;
    }
}

