/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class ToolTipMouseTrackAdapter
extends MouseTrackAdapter {
    private final Composite treeOrTable;
    private final IToolTipTextProvider toolTipTextProvider;

    public ToolTipMouseTrackAdapter(Composite treeOrTable, IToolTipTextProvider toolTipTextProvider) {
        this.treeOrTable = treeOrTable;
        this.toolTipTextProvider = toolTipTextProvider;
    }

    public void mouseHover(MouseEvent e) {
        if (!this.treeOrTable.isDisposed()) {
            Item item = this.getItem(new Point(e.x, e.y));
            if (item == null) {
                this.treeOrTable.setToolTipText(null);
            } else {
                this.treeOrTable.setToolTipText(this.toolTipTextProvider.getToolTipText(this.getElement(item)));
            }
        }
    }

    private Object getElement(Item item) {
        Object object = item.getData();
        if (object instanceof Row) {
            return ((Row)object).getElement();
        }
        return object;
    }

    private Item getItem(Point point) {
        if (this.treeOrTable instanceof Table) {
            return ((Table)this.treeOrTable).getItem(point);
        }
        if (this.treeOrTable instanceof Tree) {
            return ((Tree)this.treeOrTable).getItem(point);
        }
        return null;
    }

    public void mouseExit(MouseEvent e) {
        this.treeOrTable.setToolTipText(null);
    }
}

