/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import com.jrockit.mc.core.CorePlugin;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormText;

public class ToolTipManager
implements MouseTrackListener,
DisposeListener,
KeyListener {
    protected static final Pattern LT = Pattern.compile("<");
    protected static final Pattern GT = Pattern.compile(">");
    protected final Composite m_composite;
    protected final Listener m_labelListener;
    protected final ToolTipProvider m_toolTipProvider;
    protected Shell m_toolTip;

    public ToolTipManager(Composite composite, ToolTipProvider toolTipProvider) {
        this.m_composite = composite;
        this.m_labelListener = new LabelListener();
        this.m_toolTipProvider = toolTipProvider;
        composite.addMouseTrackListener((MouseTrackListener)this);
        composite.addDisposeListener((DisposeListener)this);
        composite.addKeyListener((KeyListener)this);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        this.destroyTip();
    }

    public void keyPressed(KeyEvent e) {
        this.destroyTip();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        this.destroyTip();
    }

    public void destroyTip() {
        if (this.m_toolTip != null && !this.m_toolTip.isDisposed()) {
            this.m_toolTip.dispose();
        }
    }

    public boolean initializeToolTip(FormText text, int x, int y) {
        if (this.m_toolTipProvider != null) {
            return this.m_toolTipProvider.initializeToolTip(text, x, y);
        }
        return false;
    }

    public void mouseHover(MouseEvent e) {
        Display display;
        if (this.m_toolTip != null && !this.m_toolTip.isDisposed()) {
            this.destroyTip();
        }
        if (this.m_composite != null && !this.m_composite.isDisposed() && (display = this.m_composite.getDisplay()) != null && !display.isDisposed()) {
            int height = display.getCursorControl() == null ? 16 : display.getCursorSizes()[0].y;
            Point pt = this.m_composite.toDisplay(e.x, e.y + height);
            this.showTip(pt.x, pt.y, e.x, e.y);
        }
    }

    public static String formatRow(String text) {
        return "<p vspace='false'>" + ToolTipManager.htmlify(text) + "</p>";
    }

    public static String formatRow(String text, boolean vspace) {
        if (vspace) {
            return "<p>" + ToolTipManager.htmlify(text) + "</p>";
        }
        return "<p vspace='false'>" + ToolTipManager.htmlify(text) + "</p>";
    }

    public static String formatRowPrimitive(String text) {
        return "<p vspace='false'>" + text + "</p>";
    }

    public static String htmlify(String text) {
        text = GT.matcher(text).replaceAll("&gt;");
        text = LT.matcher(text).replaceAll("&lt;");
        return text;
    }

    public static String formatBoldRow(String text) {
        return "<p vspace='false'><b>" + ToolTipManager.htmlify(text) + "</b></p>";
    }

    private static boolean hasValidShell(Shell shell) {
        return shell != null && !shell.isDisposed();
    }

    private static boolean hasValidDisplay(Display display) {
        return display != null && !display.isDisposed();
    }

    public void showTip(int showX, int showY, int atX, int atY) {
        Shell shell = this.m_composite.getShell();
        Display display = this.m_composite.getDisplay();
        if (ToolTipManager.hasValidShell(shell) && ToolTipManager.hasValidDisplay(display)) {
            this.m_toolTip = new Shell(shell, 16388);
            FormText formText = new FormText((Composite)this.m_toolTip, 64);
            try {
                if (this.initializeToolTip(formText, atX, atY)) {
                    this.activateTip(showX, showY, display, formText);
                    return;
                }
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when initializing ToolTip", e);
            }
            if (formText != null && !formText.isDisposed()) {
                formText.dispose();
            }
            if (this.m_toolTip != null && !this.m_toolTip.isDisposed()) {
                this.m_toolTip.dispose();
            }
        }
    }

    private void activateTip(int showX, int showY, Display display, FormText label) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 1;
        this.m_toolTip.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1, 1, false, true);
        label.setLayoutData((Object)gd);
        this.m_toolTip.setForeground(display.getSystemColor(28));
        this.m_toolTip.setBackground(display.getSystemColor(29));
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.addListener(7, this.m_labelListener);
        label.addListener(3, this.m_labelListener);
        this.m_toolTip.layout();
        Point size = this.m_toolTip.computeSize(-1, -1);
        this.m_toolTip.setBounds(showX, showY, size.x, size.y);
        this.m_toolTip.setVisible(true);
    }

    private final class LabelListener
    implements Listener {
        private LabelListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 3 || event.type == 7) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                shell.dispose();
            }
        }
    }

    public static interface ToolTipProvider {
        public boolean initializeToolTip(FormText var1, int var2, int var3);
    }
}

