/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ProgressCircle
extends JComponent {
    private static final long serialVersionUID = -7643464242630006633L;
    private static final int DEFAULT_SUBDIVISIONS = 36;
    private static final double DEFAULT_SIZE = 0.8;
    private static final double DEFAULT_INNER_CIRCLE_SIZE = 0.2;
    private volatile Color[] colors;
    private int subdivisions;
    private int alpha;
    private int innerOuterAlphaOffset = 0;
    private double innerOuterGap = 0.025;
    private double relativeSize;
    private double innerCircleSize = 0.2;
    private double innerOuterRatio = 0.85;
    private double fractionOfCircleToColour = 0.8;
    private double fractionOfArcToColour = 0.25;
    private double decayPower = 6.0;
    private Direction innerDirection = Direction.CLOCKWISE;
    private Direction outerDirection = Direction.COUNTERCLOCKWISE;

    public ProgressCircle() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setDoubleBuffered(true);
        this.setSubdivisions(36);
        this.setRelativeSize(0.8);
    }

    public void setSubdivisions(int subdivisions) {
        this.subdivisions = subdivisions;
        this.initializeColours(subdivisions);
    }

    private void initializeColours(int subdivisions) {
        Color[] newColors = new Color[subdivisions];
        int i = 0;
        while (i < subdivisions) {
            newColors[i] = this.getBackground();
            ++i;
        }
        int toColor = Math.min(newColors.length, (int)Math.round((double)subdivisions * this.fractionOfCircleToColour));
        double angle = 360.0 / (double)toColor;
        int i2 = 0;
        while (i2 < toColor) {
            newColors[newColors.length - 1 - i2] = this.interpolateColor(360.0 - (double)i2 * angle);
            ++i2;
        }
        this.colors = newColors;
    }

    public void setRelativeSize(double relativeSize) {
        this.relativeSize = relativeSize;
    }

    public void paint(Graphics g) {
        if (this.isOpaque()) {
            this.clear(g);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int radius = (int)((double)Math.min(this.getWidth(), this.getHeight()) * this.relativeSize / 2.0);
        int innerRadius = (int)((double)radius * this.innerOuterRatio);
        int centerX = this.getWidth() / 2;
        int centerY = this.getHeight() / 2;
        if (!this.isOpaque()) {
            this.drawCenterCircle(g, centerX, centerY, radius);
        }
        this.drawOuterArcs(g, centerX, centerY, radius);
        this.drawCenterCircle(g, centerX, centerY, (int)Math.round((double)innerRadius + this.innerOuterGap * (double)radius));
        this.drawArcs(g, centerX, centerY, innerRadius);
        this.drawCenterCircle(g, centerX, centerY, (int)((double)radius * this.innerCircleSize));
    }

    private void drawOuterArcs(Graphics g, int centerX, int centerY, int radius) {
        int x = centerX - radius;
        int y = centerY - radius;
        int diameter = radius * 2;
        double angle = 360.0 / (double)this.subdivisions;
        int paintAngle = (int)Math.round(angle * this.fractionOfArcToColour);
        g.setColor(this.getForeground());
        int i = 0;
        while (i < this.subdivisions) {
            int startAngle = (int)((Math.round(angle * (double)i) + (long)this.alpha + (long)this.innerOuterAlphaOffset) * (long)this.outerDirection.getValue());
            g.setColor(this.colors[i]);
            g.fillArc(x, y, diameter, diameter, startAngle, paintAngle);
            ++i;
        }
    }

    private void clear(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void drawArcs(Graphics g, int centerX, int centerY, int radius) {
        int x = centerX - radius;
        int y = centerY - radius;
        int diameter = radius * 2;
        double angle = 360.0 / (double)this.subdivisions;
        int paintAngle = (int)Math.round(angle * this.fractionOfArcToColour);
        g.setColor(this.getForeground());
        int i = 0;
        while (i < this.subdivisions) {
            int startAngle = (int)((Math.round(angle * (double)i) + (long)this.alpha) * (long)this.innerDirection.getValue());
            g.setColor(this.colors[i]);
            g.fillArc(x, y, diameter, diameter, startAngle, paintAngle);
            ++i;
        }
    }

    private Color interpolateColor(double angle) {
        double fraction = this.power(angle);
        int redDelta = (int)Math.round((double)(this.getForeground().getRed() - this.getBackground().getRed()) * fraction);
        int greenDelta = (int)Math.round((double)(this.getForeground().getGreen() - this.getBackground().getGreen()) * fraction);
        int blueDelta = (int)Math.round((double)(this.getForeground().getBlue() - this.getBackground().getBlue()) * fraction);
        return new Color(this.getBackground().getRed() + redDelta, this.getBackground().getGreen() + greenDelta, this.getBackground().getBlue() + blueDelta);
    }

    private void drawCenterCircle(Graphics g, int centerX, int centerY, int radius) {
        g.setColor(this.getBackground());
        g.fillOval(centerX - radius, centerY - radius, radius * 2, radius * 2);
    }

    public void setAngle(int alpha) {
        double angle = 360.0 / (double)this.subdivisions;
        this.alpha = (int)((double)Math.round((double)alpha / angle) * angle);
    }

    public double power(double angle) {
        return Math.pow(0.002777777777777778 * angle, this.decayPower);
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.initializeColours(this.subdivisions);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.initializeColours(this.subdivisions);
    }

    public void setInnerOuterRatio(double innerOuterRatio) {
        this.innerOuterRatio = innerOuterRatio;
    }

    public void setInnerOuterGap(double innerOuterGap) {
        this.innerOuterGap = innerOuterGap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        CLOCKWISE(-1),
        COUNTERCLOCKWISE(1);

        private int value;

        private Direction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

