/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OnePageWizardDialog
extends WizardDialog {
    private String m_title;
    private Image m_image;
    private Point m_widthContraint = new Point(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private Point m_heightContraint = new Point(Integer.MIN_VALUE, Integer.MAX_VALUE);

    public OnePageWizardDialog(Shell shell, IWizardPage page) {
        super(shell, (IWizard)new OnePageWizard(page));
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.getOnePageWizard().setDialogSettings(settings);
    }

    public IDialogSettings getDialogSettings() {
        return this.getOnePageWizard().getDialogSettings();
    }

    public IWizardPage getPage() {
        return this.getOnePageWizard().getPage();
    }

    private OnePageWizard getOnePageWizard() {
        return (OnePageWizard)this.getWizard();
    }

    public void setImage(Image image) {
        this.m_image = image;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setWidthConstaint(int min, int max) {
        this.m_widthContraint = new Point(min, max);
    }

    public void setHeightConstraint(int min, int max) {
        this.m_heightContraint = new Point(min, max);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.m_image != null) {
            this.getShell().setImage(this.m_image);
        }
        if (this.m_title != null) {
            this.getShell().setText(this.m_title);
        }
        this.updateShellSize();
        DisplayToolkit.placeDialogInCenter(this.getParentShell(), this.getShell());
        this.getButton(16).setText(IDialogConstants.OK_LABEL);
        return control;
    }

    private void updateShellSize() {
        this.getShell().pack();
        Point size = this.getShell().getSize();
        int width = OnePageWizardDialog.calculateConstrained(this.m_widthContraint.x, size.x, this.m_widthContraint.y);
        int height = OnePageWizardDialog.calculateConstrained(this.m_heightContraint.x, size.y, this.m_heightContraint.y);
        if (width != size.x || height != size.y) {
            this.getShell().setSize(new Point(width, height));
        }
    }

    private static int calculateConstrained(int min, int preferred, int max) {
        return Math.min(Math.max(min, preferred), max);
    }

    public boolean performFinish() {
        return this.getWizard().performFinish();
    }

    private static class OnePageWizard
    extends Wizard {
        private final IWizardPage m_page;

        public OnePageWizard(IWizardPage page) {
            this.m_page = page;
        }

        public boolean performFinish() {
            if (this.m_page instanceof IPerformFinishable) {
                return ((IPerformFinishable)this.m_page).performFinish();
            }
            return true;
        }

        public void addPages() {
            this.addPage(this.m_page);
        }

        public IWizardPage getPage() {
            return this.m_page;
        }
    }
}

