/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import com.jrockit.mc.core.misc.ui.IntFieldEditor;
import com.jrockit.mc.core.misc.ui.SubclassableRadioGroupFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class NestedRadioGroupFieldEditor
extends SubclassableRadioGroupFieldEditor {
    protected FieldEditor[] editors;
    protected Object[] editorParams;
    protected int selectedIndex;

    public NestedRadioGroupFieldEditor(String name, String labelText, String[][] labelAndValues, Object[] editorParams, Composite parent) {
        super(name, labelText, 3, labelAndValues, parent, true);
        this.editorParams = editorParams;
        if (labelAndValues.length != editorParams.length) {
            throw new IllegalArgumentException("The arrays labelAndValues and editorParams must have the same length");
        }
        this.editors = new FieldEditor[editorParams.length];
        this.createControl(parent);
    }

    public Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.labelsAndValues.length];
            int i = 0;
            while (i < this.labelsAndValues.length) {
                Button radio;
                this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                String[] labelAndValue = this.labelsAndValues[i];
                radio.setText(labelAndValue[0]);
                radio.setData((Object)labelAndValue[1]);
                radio.setFont(font);
                GridData data = new GridData(768);
                if (labelAndValue.length > 3) {
                    if (this.editorParams[i] instanceof int[]) {
                        int[] params = (int[])this.editorParams[i];
                        IntFieldEditor intEditor = new IntFieldEditor(labelAndValue[2], labelAndValue[3], this.radioBox, params[0]);
                        if (params.length > 2) {
                            intEditor.setValidRange(params[1], params[2]);
                        }
                        intEditor.setEnabled(false, this.radioBox);
                        intEditor.adjustForNumColumns(this.numColumns - 1);
                        this.editors[i] = intEditor;
                    }
                    data.horizontalSpan = 1;
                } else {
                    data.horizontalSpan = this.numColumns;
                }
                radio.setLayoutData((Object)data);
                radio.addSelectionListener((SelectionListener)new NestedEnableDisabler(i));
                ++i;
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    NestedRadioGroupFieldEditor.this.radioBox = null;
                    NestedRadioGroupFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = this.numColumns;
        this.radioBox.setLayout((Layout)layout);
        return this.radioBox;
    }

    protected void updateValue(String selectedValue) {
        super.updateValue(selectedValue);
        if (this.radioButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                boolean selected = this.radioButtons[i].getSelection();
                this.editors[i].setEnabled(selected, this.radioBox);
                if (selected) {
                    this.selectedIndex = i;
                }
            }
            ++i;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].setEnabled(enabled && i == this.selectedIndex, this.radioBox);
            }
            ++i;
        }
    }

    protected void doLoad() {
        super.doLoad();
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].load();
            }
            ++i;
        }
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].loadDefault();
            }
            ++i;
        }
    }

    protected void doStore() {
        super.doStore();
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].store();
            }
            ++i;
        }
    }

    public void setPage(DialogPage dialogPage) {
        super.setPage(dialogPage);
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].setPage(dialogPage);
            }
            ++i;
        }
    }

    public void setPropertyChangeListener(IPropertyChangeListener listener) {
        super.setPropertyChangeListener(listener);
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].setPropertyChangeListener(listener);
            }
            ++i;
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].setPreferenceStore(store);
            }
            ++i;
        }
    }

    protected class NestedEnableDisabler
    extends SelectionAdapter {
        private int index;

        public NestedEnableDisabler(int index) {
            this.index = index;
        }

        public void widgetSelected(SelectionEvent event) {
            String oldValue = NestedRadioGroupFieldEditor.this.value;
            NestedRadioGroupFieldEditor.this.value = (String)event.widget.getData();
            NestedRadioGroupFieldEditor.this.setPresentsDefaultValue(false);
            if (NestedRadioGroupFieldEditor.this.editors[NestedRadioGroupFieldEditor.this.selectedIndex] != null) {
                NestedRadioGroupFieldEditor.this.editors[NestedRadioGroupFieldEditor.this.selectedIndex].setEnabled(false, NestedRadioGroupFieldEditor.this.radioBox);
            }
            if (NestedRadioGroupFieldEditor.this.editors[this.index] != null) {
                NestedRadioGroupFieldEditor.this.editors[this.index].setEnabled(true, NestedRadioGroupFieldEditor.this.radioBox);
            }
            NestedRadioGroupFieldEditor.this.selectedIndex = this.index;
            NestedRadioGroupFieldEditor.this.fireValueChanged("field_editor_value", (Object)oldValue, (Object)NestedRadioGroupFieldEditor.this.value);
        }
    }
}

