/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import com.jrockit.mc.core.misc.ui.Messages;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileSelector
extends Composite {
    public static final String PROPERTY_NO_FILE_SPECIFIED = "no.file.specified";
    public static final String PROPERTY_FILE_DOES_NOT_EXIST = "file.does.not.exist";
    public static final String PROPERTY_VALID_FILE_NAME_ENTERED = "valid.file.name.specified";
    public static final String LAST_FILE_NAME = "last.file.name";
    private static final String FILE_EXTENSION_SEPARATOR = ".";
    private final IDialogSettings m_settings;
    private final ListenerList m_listeners = new ListenerList();
    private final boolean m_mustExist;
    private final String m_labelText;
    private final boolean m_save;
    private File m_file;
    private Text m_filename;
    private String m_fileExtension;

    public FileSelector(Composite parent, IDialogSettings settings, String label, boolean mustExistToBeValid, int style) {
        super(parent, style);
        this.m_labelText = label;
        this.m_settings = settings;
        this.m_mustExist = mustExistToBeValid;
        this.m_save = (style & 0x2000) > 0;
        this.createFileSelection(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FileSelector.this.m_listeners.clear();
            }
        });
        this.updateFileName();
    }

    public void setFileExtension(String extension) {
        this.m_fileExtension = FILE_EXTENSION_SEPARATOR + extension;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.m_listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.m_listeners.remove((Object)listener);
    }

    protected void firePropertyChange(String property, String message) {
        Object[] objects = this.m_listeners.getListeners();
        int n = 0;
        while (n < objects.length) {
            IPropertyChangeListener p = (IPropertyChangeListener)objects[n];
            p.propertyChange(new PropertyChangeEvent((Object)this, property, null, (Object)message));
            ++n;
        }
    }

    protected void updateFileName() {
        if (this.m_filename.getText() == null || this.m_filename.getText().trim().length() == 0) {
            this.m_file = null;
            this.firePropertyChange(PROPERTY_NO_FILE_SPECIFIED, Messages.FileSelectorComposite_PLEASE_SPECIFY_FILE);
            return;
        }
        File file = new File(this.m_filename.getText());
        if (file.isDirectory()) {
            this.firePropertyChange(PROPERTY_NO_FILE_SPECIFIED, Messages.FileSelectorComposite_PLEASE_SPECIFY_FILE);
            return;
        }
        if (this.m_mustExist && !file.exists()) {
            this.m_file = null;
            this.firePropertyChange(PROPERTY_FILE_DOES_NOT_EXIST, MessageFormat.format(Messages.FILE_DOES_NOT_EXIST, this.m_filename.getText()));
            return;
        }
        this.m_file = file;
        this.firePropertyChange(PROPERTY_VALID_FILE_NAME_ENTERED, null);
    }

    public void storeFilename() {
        if (this.m_settings != null) {
            this.m_settings.put(LAST_FILE_NAME, this.m_file.toString());
        }
    }

    protected String getStoredFileName() {
        return this.m_settings != null ? this.m_settings.get(LAST_FILE_NAME) : null;
    }

    protected Composite createFileSelection(Composite container) {
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gridDataLabel = new GridData(4, 0x1000000, false, false);
        Label l = this.createLabel(container, this.m_labelText);
        l.setLayoutData((Object)gridDataLabel);
        GridData gridDataFileName = new GridData(4, 0x1000000, true, false);
        this.m_filename = this.createTextInput(container);
        this.m_filename.setLayoutData((Object)gridDataFileName);
        GridData gridDataFileSelectionButton = new GridData(4, 0x1000000, false, false);
        Button fileSectionButton = this.createBrowseButton(container, this.m_filename);
        fileSectionButton.setLayoutData((Object)gridDataFileSelectionButton);
        return container;
    }

    protected Text createTextInput(Composite container) {
        Text text = new Text(container, 2048);
        String fileName = this.getStoredFileName();
        text.setText(fileName == null ? "" : fileName);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSelector.this.updateFileName();
            }
        });
        return text;
    }

    protected Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        return label;
    }

    protected Button createBrowseButton(Composite container, final Text textInput) {
        Button fileSectionButton = new Button(container, 0);
        fileSectionButton.setText(Messages.FileSelectorComposite_FILE_SELECTOR_BROWSE_BUTTON_TEXT);
        fileSectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file;
                if (!textInput.isDisposed() && (file = FileSelector.this.selectFile(textInput.getShell())) != null) {
                    textInput.setText(file.toString());
                    textInput.setSelection(textInput.getText().length());
                    FileSelector.this.updateFileName();
                }
            }
        });
        return fileSectionButton;
    }

    protected File selectFile(Shell shell) {
        String defaultPath;
        FileDialog dialog = new FileDialog(shell, this.m_save ? 8192 : 4096);
        dialog.setFilterExtensions(new String[]{"*" + this.m_fileExtension == null ? "" : "*" + this.m_fileExtension});
        if ((this.m_filename.getText() == null || this.m_filename.getText().trim().length() == 0) && (defaultPath = this.getDefaultPath()) != null) {
            dialog.setFilterPath(defaultPath);
        }
        dialog.open();
        return this.makeFile(dialog.getFilterPath(), dialog.getFileName());
    }

    protected String getDefaultPath() {
        return System.getProperty("user.home");
    }

    protected File makeFile(String filterPath, String fileName) {
        if (fileName.length() != 0) {
            if (fileName.indexOf(FILE_EXTENSION_SEPARATOR) == -1 && this.m_fileExtension != null && !fileName.endsWith(this.m_fileExtension)) {
                fileName = String.valueOf(fileName) + this.m_fileExtension;
            }
            return new File(filterPath, fileName);
        }
        return null;
    }

    public File getFile() {
        return this.m_file;
    }
}

