/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayToolkit {
    private static final ChannelRepository channelRepository = new ChannelRepository();

    public static void placeDialogInCenter(Shell parent, Shell shell) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static void dispose(Widget widget) {
        if (DisplayToolkit.isSafe(widget)) {
            widget.dispose();
        }
    }

    public static void safeAsyncExec(Widget widget, Runnable runnable) {
        new SafeWidgetRunnable(runnable, widget).asyncExec();
    }

    public static void safeSyncExec(Widget widget, Runnable runnable) {
        new SafeWidgetRunnable(runnable, widget).syncExec();
    }

    public static void safeAsyncExec(Display display, Runnable runnable) {
        new SafeDisplayRunnable(runnable, display).asyncExec();
    }

    public static void safeSyncExec(Display display, Runnable runnable) {
        new SafeDisplayRunnable(runnable, display).syncExec();
    }

    public static void safeTimerExec(final Display display, final int milliseconds, final Runnable runnable) {
        DisplayToolkit.safeSyncExec(display, new Runnable(){

            public void run() {
                new SafeDisplayRunnable(runnable, display).timerExec(milliseconds);
            }
        });
    }

    public static void safeTimerExec(final Widget widget, final int milliseconds, final Runnable runnable) {
        DisplayToolkit.safeSyncExec(widget, new Runnable(){

            public void run() {
                new SafeWidgetRunnable(runnable, widget).timerExec(milliseconds);
            }
        });
    }

    public static void safeWithinExec(Widget widget, int milliseconds, Runnable runnable) {
        DisplayToolkit.safeWithinExec(widget, milliseconds, DisplayToolkit.class, runnable);
    }

    public static void safeWithinExec(Widget widget, int milliseconds, Object channel, Runnable runnable) {
        SafeWidgetRunnableChannel safeRunnable = SafeWidgetRunnableChannel.createIfEmptyChannel(runnable, widget, SafeDisplayRunnableChannel.class);
        if (safeRunnable != null) {
            DisplayToolkit.safeTimerExec(widget, milliseconds, (Runnable)safeRunnable);
        }
    }

    public static void safeWithinExec(Display display, int milliseconds, Runnable runnable) {
        DisplayToolkit.safeWithinExec(display, milliseconds, SafeDisplayRunnableChannel.class, runnable);
    }

    public static void safeWithinExec(Display display, int milliseconds, Object channel, Runnable runnable) {
        SafeDisplayRunnableChannel safeRunnable = SafeDisplayRunnableChannel.createIfEmptyChannel(runnable, display, channel);
        if (safeRunnable != null) {
            DisplayToolkit.safeTimerExec(display, milliseconds, (Runnable)safeRunnable);
        }
    }

    public static boolean isSafe(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    private static class ChannelRepository {
        private final Set<Object> s_channels = new HashSet<Object>();

        private ChannelRepository() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseChannelLock(Object channel) {
            Set<Object> set = this.s_channels;
            synchronized (set) {
                this.s_channels.remove(channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean acquireChannelLock(Object channel) {
            Set<Object> set = this.s_channels;
            synchronized (set) {
                return this.s_channels.add(channel);
            }
        }
    }

    public static class SafeDisplayRunnable
    extends SafeRunnable {
        private final Display m_display;

        public SafeDisplayRunnable(Runnable runnable, Display display) {
            super(runnable);
            this.m_display = display;
        }

        public static boolean isSafe(Display display) {
            return display != null && !display.isDisposed();
        }

        protected Display getDisplay() {
            return this.m_display;
        }

        protected boolean isSafe() {
            return SafeDisplayRunnable.isSafe(this.m_display);
        }
    }

    public static class SafeDisplayRunnableChannel
    extends SafeDisplayRunnable {
        private final Object m_channel;

        private SafeDisplayRunnableChannel(Runnable runnable, Display display, Object channel) {
            super(runnable, display);
            this.m_channel = channel;
        }

        public void run() {
            channelRepository.releaseChannelLock(this.m_channel);
            if (this.isSafe()) {
                this.m_runnable.run();
            }
        }

        public static SafeDisplayRunnableChannel createIfEmptyChannel(Runnable runnable, Display display, Object channel) {
            if (channelRepository.acquireChannelLock(channel)) {
                return new SafeDisplayRunnableChannel(runnable, display, channel);
            }
            return null;
        }
    }

    public static abstract class SafeRunnable
    implements Runnable {
        protected final Runnable m_runnable;

        public SafeRunnable(Runnable runnable) {
            this.m_runnable = runnable;
        }

        public void run() {
            if (this.isSafe()) {
                this.m_runnable.run();
            }
        }

        protected abstract boolean isSafe();

        protected abstract Display getDisplay();

        protected void asyncExec() {
            if (this.isSafe()) {
                this.getDisplay().asyncExec((Runnable)this);
            }
        }

        protected void syncExec() {
            if (this.isSafe()) {
                this.getDisplay().syncExec((Runnable)this);
            }
        }

        protected void timerExec(int millis) {
            if (this.isSafe()) {
                this.getDisplay().timerExec(millis, (Runnable)this);
            }
        }
    }

    public static class SafeWidgetRunnable
    extends SafeRunnable {
        private final Widget m_widget;

        public SafeWidgetRunnable(Runnable runnable, Widget widget) {
            super(runnable);
            this.m_widget = widget;
        }

        protected boolean isSafe() {
            if (DisplayToolkit.isSafe(this.m_widget)) {
                return SafeDisplayRunnable.isSafe(this.m_widget.getDisplay());
            }
            return false;
        }

        protected Display getDisplay() {
            return this.m_widget.getDisplay();
        }
    }

    public static class SafeWidgetRunnableChannel
    extends SafeWidgetRunnable {
        private final Object m_channel;

        private SafeWidgetRunnableChannel(Runnable runnable, Widget widget, Object channel) {
            super(runnable, widget);
            this.m_channel = channel;
        }

        public void run() {
            channelRepository.releaseChannelLock(this.m_channel);
            if (this.isSafe()) {
                this.m_runnable.run();
            }
        }

        public static SafeWidgetRunnableChannel createIfEmptyChannel(Runnable runnable, Widget widget, Object channel) {
            if (channelRepository.acquireChannelLock(channel)) {
                return new SafeWidgetRunnableChannel(runnable, widget, channel);
            }
            return null;
        }
    }
}

