/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc.ui;

import com.jrockit.mc.core.misc.ui.Messages;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.ToolTip;

public class DateTimeController {
    private static final int WARNING_MESSAGE_Y_OFFSET_FROM_CONTROL_BOTTOM = 10;
    private final DateTime m_datePicker;
    private final DateTime m_timePicker;
    private final Calendar m_minValue;
    private final Calendar m_maxValue;
    private final Calendar m_defaultValue;
    private final Calendar m_currentDateTime;

    public DateTimeController(DateTime date, DateTime time, Calendar calenderPrototype) {
        this.m_minValue = this.createCalender(calenderPrototype, System.currentTimeMillis());
        this.m_defaultValue = this.createCalender(calenderPrototype, System.currentTimeMillis());
        this.m_maxValue = this.createCalender(calenderPrototype, System.currentTimeMillis());
        this.m_datePicker = date;
        this.m_timePicker = time;
        this.m_currentDateTime = (Calendar)calenderPrototype.clone();
        this.hookListeners();
    }

    public void setMaxValue(long millis) {
        this.m_maxValue.setTimeInMillis(millis);
        this.ceil();
        this.updatePickers();
    }

    public void setValue(long millis) {
        this.m_currentDateTime.setTimeInMillis(millis);
        this.floor();
        this.ceil();
        this.updatePickers();
    }

    public long getValue() {
        return this.m_currentDateTime.getTimeInMillis();
    }

    public void setMinValue(long millis) {
        this.m_minValue.setTimeInMillis(millis);
        this.floor();
        this.updatePickers();
    }

    public void reset() {
        this.m_currentDateTime.setTimeInMillis(this.m_defaultValue.getTimeInMillis());
        DateTimeController.calenderToDateTime(this.m_currentDateTime, this.m_datePicker, this.m_timePicker);
    }

    public DateTime getDatePicker() {
        return this.m_datePicker;
    }

    public DateTime getTimePicker() {
        return this.m_timePicker;
    }

    public static void calenderToDateTime(Calendar calendar, DateTime date, DateTime time) {
        date.setYear(calendar.get(1));
        date.setMonth(calendar.get(2));
        date.setDay(calendar.get(5));
        time.setHours(calendar.get(11));
        time.setMinutes(calendar.get(12));
        time.setSeconds(calendar.get(13));
    }

    public static void dateTimeToCalender(DateTime date, DateTime time, Calendar calendar) {
        calendar.set(date.getYear(), date.getMonth(), date.getDay(), time.getHours(), time.getMinutes(), time.getSeconds());
    }

    private void validatePicker(DateTime picker) {
        this.updateCurrentTime();
        if (this.floor()) {
            this.showTip((Composite)picker, Messages.DateTimeController_VALUE_TOO_SMALL, this.createOutOfRangeMessage());
            this.updatePickers();
        }
        if (this.ceil()) {
            this.showTip((Composite)picker, Messages.DateTimeController_VALUE_TOO_LARGE, this.createOutOfRangeMessage());
            this.updatePickers();
        }
    }

    private void hookListeners() {
        this.m_datePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeController.this.validatePicker(DateTimeController.this.m_datePicker);
            }
        });
        this.m_timePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeController.this.validatePicker(DateTimeController.this.m_timePicker);
            }
        });
    }

    private String createOutOfRangeMessage() {
        DateFormat df = DateFormat.getDateInstance(3);
        DateFormat tf = DateFormat.getTimeInstance();
        String fromDate = df.format(this.m_minValue.getTime());
        String fromTime = tf.format(this.m_minValue.getTime());
        String endDate = df.format(this.m_maxValue.getTime());
        String endTime = tf.format(this.m_maxValue.getTime());
        return MessageFormat.format(Messages.VALUE_MUST_BE_BETWEENVALUE_MUST_BE_BETWEEN_TEXT, fromDate, fromTime, endDate, endTime);
    }

    private void showTip(Composite composite, String title, String message) {
        ToolTip tooltip = new ToolTip(composite.getShell(), 4097);
        Point displayPosition = composite.toDisplay(new Point(composite.getBounds().width / 2, composite.getBounds().height + 10));
        tooltip.setLocation(displayPosition);
        tooltip.setMessage(message);
        tooltip.setText(title);
        tooltip.setVisible(true);
    }

    private Calendar createCalender(Calendar protoType, long time) {
        Calendar calendar = (Calendar)protoType.clone();
        calendar.setTimeInMillis(time);
        return calendar;
    }

    private void updatePickers() {
        DateTimeController.calenderToDateTime(this.m_currentDateTime, this.m_datePicker, this.m_timePicker);
    }

    private void updateCurrentTime() {
        DateTimeController.dateTimeToCalender(this.m_datePicker, this.m_timePicker, this.m_currentDateTime);
    }

    private boolean ceil() {
        if (this.m_maxValue.getTimeInMillis() < this.m_currentDateTime.getTimeInMillis()) {
            this.m_currentDateTime.setTimeInMillis(this.m_maxValue.getTimeInMillis());
            return true;
        }
        return false;
    }

    private boolean floor() {
        if (this.m_minValue.getTimeInMillis() > this.m_currentDateTime.getTimeInMillis()) {
            this.m_currentDateTime.setTimeInMillis(this.m_minValue.getTimeInMillis());
            return true;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.getDatePicker().setEnabled(enabled);
        this.getTimePicker().setEnabled(enabled);
    }

    public long getMinValue() {
        return this.m_minValue.getTimeInMillis();
    }

    public long getMaxValue() {
        return this.m_maxValue.getTimeInMillis();
    }
}

