/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc;

import java.util.Random;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IMessageManager;

public class TemporaryMessage {
    private final String m_key;
    private final String m_messageText;
    private final Object m_data;
    private final int m_type;
    private int m_delay = 2000;

    public TemporaryMessage(String messageText, int type) {
        this(null, messageText, null, type);
    }

    public TemporaryMessage(String key, String messageText, Object data, int type) {
        this.m_key = key == null ? Long.toString(new Random().nextLong()) : key;
        this.m_type = type;
        this.m_data = data;
        this.m_messageText = messageText == null ? "" : messageText;
    }

    public TemporaryMessage(IStatus status) {
        this(null, status.getMessage(), null, TemporaryMessage.translateStatusCodeToMessageProviderCode(status.getSeverity()));
    }

    private static int translateStatusCodeToMessageProviderCode(int statusCode) {
        if (statusCode == 4) {
            return 3;
        }
        if (statusCode == 2) {
            return 2;
        }
        if (statusCode == 1) {
            return 1;
        }
        return 0;
    }

    public void setDelay(int millis) {
        this.m_delay = millis;
    }

    public int getDelay() {
        return this.m_delay;
    }

    public void show(IMessageManager manager, Display display) {
        assert (TemporaryMessage.idDisplayOK(display));
        this.showMessage(manager, display);
        this.hideMessage(manager, display);
    }

    private void showMessage(final IMessageManager manager, final Display display) {
        if (TemporaryMessage.idDisplayOK(display)) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (TemporaryMessage.idDisplayOK(display)) {
                        manager.addMessage((Object)TemporaryMessage.this.m_key, TemporaryMessage.this.m_messageText, TemporaryMessage.this.m_data, TemporaryMessage.this.m_type);
                    }
                }
            });
        }
    }

    private static boolean idDisplayOK(Display display) {
        return display != null && !display.isDisposed();
    }

    private void hideMessage(final IMessageManager manager, final Display display) {
        if (TemporaryMessage.idDisplayOK(display)) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (TemporaryMessage.idDisplayOK(display)) {
                        display.timerExec(TemporaryMessage.this.m_delay, new Runnable(){

                            public void run() {
                                if (TemporaryMessage.idDisplayOK(display)) {
                                    manager.removeMessage((Object)TemporaryMessage.this.m_key);
                                }
                            }
                        });
                    }
                }
            });
        }
    }
}

