/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class StatusFactory {
    public static IStatus createErr(String message, Throwable cause, boolean showStackTrace) {
        String subMsg;
        if (cause == null) {
            return StatusFactory.createErr(message);
        }
        Object status = showStackTrace ? StatusFactory.expandStackTrace(cause) : new Status(4, "com.jrockit.mc.core", 0, (subMsg = cause.getLocalizedMessage()) != null ? subMsg : cause.getClass().getName(), null);
        return new MultiStatus("com.jrockit.mc.core", 0, new IStatus[]{status}, message, null);
    }

    public static IStatus createErr(String message) {
        return new Status(4, "com.jrockit.mc.core", 0, message, null);
    }

    public static IStatus createOk(String message) {
        return new Status(0, "com.jrockit.mc.core", 0, message, null);
    }

    private static IStatus expandStackTrace(Throwable e) {
        StringWriter writer = new StringWriter(64);
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.flush();
        String[] lines = writer.toString().split("[\r\n]+");
        IStatus[] statuses = new IStatus[lines.length];
        int i = 0;
        while (i < statuses.length) {
            statuses[i] = new Status(4, "com.jrockit.mc.core", 0, lines[i], null);
            ++i;
        }
        return new MultiStatus("com.jrockit.mc.core", 0, statuses, String.valueOf(e.getClass().getName()) + ": " + e.getLocalizedMessage(), null);
    }
}

