/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDialog
extends MessageDialog {
    private Throwable detail;
    private int detailButtonID = -1;
    private Text text;
    private int defaultButtonIndex = 0;
    private static final int TEXT_LINE_COUNT = 15;

    public ExceptionDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, Throwable detail, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.defaultButtonIndex = defaultIndex;
        this.detail = detail;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public int open() {
        this.create();
        Button b = this.getButton(this.defaultButtonIndex);
        b.setFocus();
        b.getShell().setDefaultButton(b);
        return super.open();
    }

    public void setDetailButton(int index) {
        this.detailButtonID = index;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == this.detailButtonID) {
            this.toggleDetailsArea();
        } else {
            this.setReturnCode(buttonId);
            this.close();
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getContents().computeSize(-1, -1);
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
            this.getButton(this.detailButtonID).setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.createDropDownText((Composite)this.getContents());
            this.getButton(this.detailButtonID).setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    protected void createDropDownText(Composite parent) {
        this.text = new Text(parent, 2816);
        this.text.setFont(parent.getFont());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            this.detail.printStackTrace(ps);
            ps.flush();
            baos.flush();
            this.text.setText(baos.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GridData data = new GridData(1808);
        data.heightHint = this.text.getLineHeight() * 15;
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
    }

    public static boolean openExceptionDialog(Shell parent, String title, String message, Throwable detail) {
        String[] labels = detail == null ? new String[]{IDialogConstants.OK_LABEL} : new String[]{IDialogConstants.OK_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        if (message == null || message.trim().length() == 0) {
            message = NLS.bind((String)"An unanticipated {0} occurred", (Object)(detail != null ? detail.getClass().getName() : "exception"));
        }
        ExceptionDialog dialog = new ExceptionDialog(parent, title, null, message, detail, 1, labels, 0);
        if (detail != null) {
            dialog.setDetailButton(1);
        }
        return dialog.open() == 0;
    }
}

