/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.misc;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.ExceptionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialog {
    private ErrorDialog() {
    }

    public static void showError(Shell shell, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static void showException(Shell shell, String title, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, t.getMessage(), t);
    }

    public static void showException(Shell shell, String title, String message, Throwable t) {
        ExceptionDialog.openExceptionDialog(shell, title, message, t);
    }

    public static synchronized void showExceptionDialogAsync(final Display display, final String title, final String message, final Throwable t) {
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.showException(display.getActiveShell(), title, message, t);
            }
        });
    }

    public static synchronized void showExceptionDialogAsync(Display display, String title, Throwable t) {
        ErrorDialog.showExceptionDialogAsync(display, title, t.getMessage(), t);
    }

    public static synchronized void showExceptionDialogAsync(String title, Throwable t) {
        ErrorDialog.showExceptionDialogAsync(CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), title, t.getMessage(), t);
    }

    public static synchronized void showExceptionDialogAsync(String title, String message, Throwable t) {
        ErrorDialog.showExceptionDialogAsync(CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), title, message, t);
    }

    public static synchronized void showErrorDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.showError(display.getActiveShell(), title, message);
            }
        });
    }

    public static synchronized void showWarningDialogAsync(final Display display, final String title, final String message) {
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)display.getActiveShell(), (String)title, (String)message);
            }
        });
    }
}

