/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.l10n;

import java.lang.reflect.Field;
import org.eclipse.osgi.util.NLS;

public abstract class MCNLS
extends NLS {
    private static final char[][] CHARACTER_MAP = new char[][]{{'*', '\u2022'}};

    public static void initializeMessages(String bundleName, Class clazz) {
        NLS.initializeMessages((String)bundleName, (Class)clazz);
        MCNLS.substituteCharactersInMessages(clazz);
    }

    private static void substituteCharactersInMessages(Class clazz) {
        int MOD_EXPECTED = 9;
        int MOD_MASK = 25;
        Field[] fieldArray = clazz.getDeclaredFields();
        int i = 0;
        while (i < fieldArray.length) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && field.getType() == String.class) {
                try {
                    String newValue;
                    String value = (String)field.get(null);
                    if (value != null && !(newValue = MCNLS.substituteCharactersInMessage(value)).equals(value)) {
                        field.set(null, newValue);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private static String substituteCharactersInMessage(String value) {
        int i = 0;
        while (i < CHARACTER_MAP.length) {
            value = value.replace(CHARACTER_MAP[i][0], CHARACTER_MAP[i][1]);
            ++i;
        }
        return value;
    }
}

