/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.jdtsupport;

import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.jdtsupport.IJDTSupport;
import com.jrockit.mc.core.jdtsupport.NoJDTSupport;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class JDTSupport {
    public static final String EXTENSION_POINT = "com.jrockit.mc.core.jdtsupport";
    private static final IJDTSupport INSTANCE;

    static {
        IJDTSupport support = null;
        try {
            try {
                IConfigurationElement[] element;
                IExtension[] ext;
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT);
                if (point != null && (ext = point.getExtensions()).length > 0 && (element = ext[0].getConfigurationElements()).length > 0) {
                    support = (IJDTSupport)element[0].createExecutableExtension("class");
                }
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Problem when looking for JDT support. Disabling JDT support.", e);
                if (support == null) {
                    support = new NoJDTSupport();
                }
                INSTANCE = support;
            }
        }
        finally {
            if (support == null) {
                support = new NoJDTSupport();
            }
            INSTANCE = support;
        }
    }

    private JDTSupport() {
    }

    public static IJDTSupport instance() {
        return INSTANCE;
    }

    public static boolean hasOpenSourceCodeSupport() {
        return INSTANCE.hasOpenSourceCodeSupport();
    }

    public static void openType(IMCType type) {
        INSTANCE.openType(type);
    }

    public static void openMethod(IMCMethod method) {
        INSTANCE.openMethod(method);
    }
}

