/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.idesupport;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.idesupport.BasicIDESupport;
import com.jrockit.mc.core.idesupport.IIDESupport;
import java.util.TreeMap;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class IDESupportFactory {
    public static final String IDE_SUPPORT_EXTENSION_POINT_NAME = "com.jrockit.mc.core.idesupport";

    public static IIDESupport getIDESupport() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final IIDESupport INSTANCE;

        static {
            IIDESupport support = null;
            try {
                try {
                    IExtensionRegistry registry = Platform.getExtensionRegistry();
                    IExtensionPoint exPoint = registry.getExtensionPoint(IDESupportFactory.IDE_SUPPORT_EXTENSION_POINT_NAME);
                    if (exPoint != null) {
                        IExtension[] ext = exPoint.getExtensions();
                        TreeMap<String, IConfigurationElement> extensionMap = new TreeMap<String, IConfigurationElement>();
                        int i = 0;
                        while (i < ext.length) {
                            IConfigurationElement[] elements = ext[i].getConfigurationElements();
                            int j = 0;
                            while (j < elements.length) {
                                extensionMap.put(elements[j].getAttribute("id"), elements[j]);
                                ++j;
                            }
                            ++i;
                        }
                        IConfigurationElement firstElement = (IConfigurationElement)extensionMap.get(extensionMap.firstKey());
                        if (firstElement != null) {
                            support = (IIDESupport)firstElement.createExecutableExtension("class");
                        }
                    }
                }
                catch (Exception e) {
                    CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Problem when looking for IDE support. Will use the basic IDE support with limited ussage.");
                    if (support == null) {
                        support = new BasicIDESupport();
                    }
                    INSTANCE = support;
                }
            }
            finally {
                if (support == null) {
                    support = new BasicIDESupport();
                }
                INSTANCE = support;
            }
        }

        private SingletonHolder() {
        }
    }
}

