/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.idesupport;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.idesupport.IFiletypeOpener;
import com.jrockit.mc.core.idesupport.OpenHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiletypeManager {
    public OpenHandler getFileOpener(String fileName) {
        IFiletypeOpener[] openers = this.getFiletypeOpeners();
        int n = 0;
        while (n < openers.length) {
            String[] fileExtensions = openers[n].getFileExtensions();
            int m = 0;
            while (m < fileExtensions.length) {
                if (fileName.endsWith(fileExtensions[m])) {
                    return openers[n].getCommand();
                }
                ++m;
            }
            ++n;
        }
        return null;
    }

    public IFiletypeOpener[] getFiletypeOpeners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint("com.jrockit.mc.core.filetypeopener");
        if (exPoint != null) {
            return this.getExtenders(exPoint);
        }
        return new IFiletypeOpener[0];
    }

    private IFiletypeOpener[] getExtenders(IExtensionPoint exPoint) {
        List<IFiletypeOpener> openers = this.buildOpenerList(exPoint);
        this.sortOpeners(openers);
        return openers.toArray(new IFiletypeOpener[openers.size()]);
    }

    private List<IFiletypeOpener> buildOpenerList(IExtensionPoint exPoint) {
        ArrayList<IFiletypeOpener> openers = new ArrayList<IFiletypeOpener>();
        IExtension[] ext = exPoint.getExtensions();
        int i = 0;
        while (i < ext.length) {
            IConfigurationElement[] element = ext[i].getConfigurationElements();
            int j = 0;
            while (j < element.length) {
                IFiletypeOpener opener = this.createOpener(element[j]);
                if (opener != null) {
                    openers.add(opener);
                }
                ++j;
            }
            ++i;
        }
        return openers;
    }

    private void sortOpeners(List<IFiletypeOpener> openers) {
        Collections.sort(openers, new Comparator<IFiletypeOpener>(){

            @Override
            public int compare(IFiletypeOpener f1, IFiletypeOpener f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
    }

    private IFiletypeOpener createOpener(IConfigurationElement element) {
        try {
            String name = this.getName(element);
            String description = this.getDescription(element);
            OpenHandler opener = this.getOpenerCommand(element);
            String[] fileTypes = this.getFileExtensions(element, name);
            String[] fileExtensionNames = this.getFileExtensionNames(element, name);
            return new FiletypeOpener(name, description, fileTypes, fileExtensionNames, opener);
        }
        catch (Exception e) {
            CorePlugin.getDefault().getLogger().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private String getDescription(IConfigurationElement element) throws Exception {
        String description = element.getAttribute("description");
        if (description == null) {
            throw new Exception("Could not find required description attribute for extension point com.jrockit.mc.core.filetypeopener");
        }
        return description;
    }

    private String getName(IConfigurationElement element) throws Exception {
        String name = element.getAttribute("name");
        if (name == null) {
            throw new Exception("Could not find required name attribute for extension point com.jrockit.mc.core.filetypeopener");
        }
        return name;
    }

    private OpenHandler getOpenerCommand(IConfigurationElement element) throws Exception {
        String className = element.getAttribute("class");
        if (className == null) {
            throw new Exception("Could not find required class attribute for extension point com.jrockit.mc.core.filetypeopener");
        }
        Object opener = element.createExecutableExtension("class");
        if (!(opener instanceof OpenHandler)) {
            throw new Exception("Class must implement  " + OpenHandler.class.getName() + " in extension point " + "com.jrockit.mc.core.filetypeopener");
        }
        return (OpenHandler)((Object)opener);
    }

    private String[] getFileExtensions(IConfigurationElement element, String name) throws Exception {
        IConfigurationElement[] elements = element.getChildren("fileextension");
        if (element == null || elements.length == 0) {
            throw new Exception("No file extension for type " + name + "in extension point " + "com.jrockit.mc.core.filetypeopener");
        }
        ArrayList<String> fileExtensions = new ArrayList<String>();
        int n = 0;
        while (n < elements.length) {
            String fileExtension = elements[n].getAttribute("fileextension");
            if (fileExtension == null) {
                throw new Exception("Error when getting file extension for type " + name + "in extension point " + "com.jrockit.mc.core.filetypeopener");
            }
            fileExtensions.add(fileExtension);
            ++n;
        }
        return fileExtensions.toArray(new String[fileExtensions.size()]);
    }

    private String[] getFileExtensionNames(IConfigurationElement element, String name) throws Exception {
        IConfigurationElement[] elements = element.getChildren("fileextension");
        if (element == null || elements.length == 0) {
            throw new Exception("No file extension name for type " + name + "in extension point " + "com.jrockit.mc.core.filetypeopener");
        }
        ArrayList<String> fileExtensionNames = new ArrayList<String>();
        int n = 0;
        while (n < elements.length) {
            String fileExtension = elements[n].getAttribute("name");
            if (fileExtension == null) {
                throw new Exception("Error when getting file extension name for type " + name + "in extension point " + "com.jrockit.mc.core.filetypeopener");
            }
            fileExtensionNames.add(fileExtension);
            ++n;
        }
        return fileExtensionNames.toArray(new String[fileExtensionNames.size()]);
    }

    private class FiletypeOpener
    implements IFiletypeOpener {
        private final String m_name;
        private final String m_description;
        private final String[] m_fileExtensions;
        private final OpenHandler m_opener;
        private final String[] m_fileExtensionNames;

        public FiletypeOpener(String name, String description, String[] fileExtensions, String[] fileExtensionNames, OpenHandler opener) {
            this.m_name = name;
            this.m_description = description;
            this.m_fileExtensions = fileExtensions;
            this.m_opener = opener;
            this.m_fileExtensionNames = fileExtensionNames;
            assert (this.m_opener != null);
            assert (this.m_name != null);
            assert (this.m_description != null);
            assert (this.m_fileExtensions != null);
            assert (this.m_fileExtensionNames != null);
        }

        public String getDescription() {
            return this.m_description;
        }

        public String[] getFileExtensions() {
            return this.m_fileExtensions;
        }

        public String getName() {
            return this.m_name;
        }

        public OpenHandler getCommand() {
            return this.m_opener;
        }

        public String[] getFileExtensionsNames() {
            return this.m_fileExtensionNames;
        }
    }
}

