/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.idesupport;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.idesupport.IIDESupport;
import com.jrockit.mc.core.idesupport.Messages;
import com.jrockit.mc.core.idesupport.TrayManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;

public class BasicIDESupport
implements IIDESupport {
    private static final String LAST_IDE_SUPPORT_PATH = "ide.support.last.browse.file";
    private TrayManager m_trayManager;

    public IPath browseForSaveAsFile(IWorkbenchWindow window, String title, String suggestedName, IPath path, String fileExtension, ImageDescriptor descriptor, String description) {
        while (true) {
            File theFile;
            FileDialog dialog = new FileDialog(window.getShell(), 8192);
            if (path != null && path.toFile().exists()) {
                dialog.setFilterPath(path.toFile().getPath());
            }
            dialog.setFilterExtensions(new String[]{fileExtension});
            dialog.setFileName(suggestedName);
            dialog.setText(title);
            String file = dialog.open();
            if (file == null) {
                return null;
            }
            String safeFileExtension = BasicIDESupport.getSafeFileExtensionWithDot(fileExtension);
            if (!file.endsWith(safeFileExtension)) {
                file = String.valueOf(file) + safeFileExtension;
            }
            if (!(theFile = new File(file)).exists()) {
                Path newPath = new Path(theFile.getPath());
                this.saveLastPath((IPath)newPath);
                return newPath;
            }
            this.showAlreadyExists(window, theFile);
        }
    }

    private void showAlreadyExists(IWorkbenchWindow window, File theFile) {
        MessageBox messageBox = new MessageBox(window.getShell(), 32);
        messageBox.setText(Messages.BasicIDESupport_FILE_ALREADY_EXIST_TITLE);
        messageBox.setMessage(String.valueOf(Messages.BasicIDESupport_FILE_ALREADY_MESSAGE_TEXT) + '\n' + theFile.getAbsolutePath());
        messageBox.open();
    }

    public File getFileFromEditorInput(IEditorInput input) {
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath().toFile();
        }
        return null;
    }

    public void checkIfWorkspaceIsInUse() throws IOException {
    }

    public IPath writeToFile(IWorkbenchWindow window, IPath filePath, InputStream in, IProgressMonitor monitor) throws IOException {
        File file = filePath.toFile();
        if (file.exists()) {
            IPath noExtension = filePath.removeFileExtension();
            File parent = file.getParentFile();
            String prefix = noExtension.lastSegment();
            assert (prefix != null);
            if (prefix == null) {
                prefix = "new";
            }
            if (prefix.length() < 3) {
                prefix = "new_" + prefix;
            }
            file = parent != null ? File.createTempFile(prefix, BasicIDESupport.getSafeFileExtensionWithDot(filePath.getFileExtension()), parent) : File.createTempFile(prefix, BasicIDESupport.getSafeFileExtensionWithDot(filePath.getFileExtension()));
            filePath = new Path(file.toString());
        }
        BasicIDESupport.transfer(filePath, in, monitor);
        return filePath;
    }

    public static void transfer(IPath filePath, InputStream in, IProgressMonitor monitor) throws IOException {
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(filePath.toFile());
            byte[] buf = new byte[0x100000];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
                monitor.worked(len);
            }
        }
        finally {
            in.close();
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getSafeFileExtensionWithDot(String fileExtension) {
        if (fileExtension == null) {
            return "";
        }
        return "." + fileExtension;
    }

    public String getLastPathKey(String suffix) {
        return LAST_IDE_SUPPORT_PATH + BasicIDESupport.getSafeFileExtensionWithDot(suffix);
    }

    public IPath getLastPath(String suffix) {
        String s = CorePlugin.getDefault().getPreferenceStore().getString(this.getLastPathKey(suffix));
        if (s != null && s.length() > 0) {
            return new Path(s);
        }
        return null;
    }

    public void saveLastPath(IPath path) {
        if (path != null) {
            CorePlugin.getDefault().getPreferenceStore().putValue(this.getLastPathKey(path.getFileExtension()), path.toOSString());
        }
    }

    public IPath getValidDefaultFile(String prefix, String suffix) {
        File directory;
        IPath path = this.getLastPath(suffix);
        if (path != null && (directory = new File(path.toOSString()).getParentFile()) != null && directory.exists()) {
            try {
                File file = File.createTempFile(prefix, BasicIDESupport.getSafeFileExtensionWithDot(suffix), directory);
                file.delete();
                return new Path(file.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            File file = File.createTempFile(prefix, BasicIDESupport.getSafeFileExtensionWithDot(suffix), new File(System.getProperty("user.home", ".\\")));
            file.delete();
            return new Path(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean supportsLoggerConfiguration() {
        return false;
    }

    public TrayManager getTrayManager() {
        return this.m_trayManager;
    }

    public void setTrayManager(TrayManager trayManager) {
        this.m_trayManager = trayManager;
    }
}

