/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.handlers;

import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.MultiField;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class MultiFieldHandler
extends AbstractHandler
implements IElementUpdater {
    private final Map m_budyCommandIdFieldMap;
    private final Field m_child;
    private ICommandService m_commandService;
    private MultiField m_mainField;

    public MultiFieldHandler(ICommandService commandService, MultiField mainField, Field child, Map commandFieldMap) {
        this.m_budyCommandIdFieldMap = commandFieldMap;
        this.m_mainField = mainField;
        this.m_commandService = commandService;
        this.m_child = child;
    }

    public void dispose() {
        this.m_budyCommandIdFieldMap.clear();
        this.m_commandService = null;
        this.m_mainField = null;
    }

    protected void updateAllChildren() {
        Iterator it = this.m_budyCommandIdFieldMap.keySet().iterator();
        while (it.hasNext()) {
            this.m_commandService.refreshElements((String)it.next(), null);
        }
    }

    protected Field getFieldFromCommandId(String id) {
        return (Field)this.m_budyCommandIdFieldMap.get(id);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object trigger = event.getTrigger();
        if (trigger instanceof Event) {
            Event e = (Event)trigger;
            MenuItem item = (MenuItem)e.widget;
            if (item.getSelection()) {
                this.m_mainField.selectField(this.getFieldFromCommandId(event.getCommand().getId()));
                this.m_mainField.notifyListeners("content.change");
                this.updateAllChildren();
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setChecked(this.m_mainField.getSelectedField() == this.m_child);
    }
}

