/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.handlers;

import com.jrockit.mc.common.debug.Debug;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class MCContextMenuManager
extends MenuManager {
    public static final String GROUP_TOP = "group.top";
    public static final String GROUP_VIEWER_SETUP = "group.viewerSetup";
    public static final String GROUP_NEW = "group.new";
    public static final String GROUP_OPEN = "group.open";
    public static final String GROUP_OPEN_WITH = "group.openWith";
    public static final String GROUP_EDIT = "group.edit";
    public static final String GROUP_ADDITIONS = "additions";
    public static final String GROUP_PROPETIES = "group.properties";

    public MCContextMenuManager(String id) {
        this(id, id);
    }

    public MCContextMenuManager(String name, String id) {
        super(name, id);
        this.initialize(id);
    }

    protected void initialize(String id) {
        if (Debug.isDebug()) {
            class ExtensionURIAction
            extends Action {
                public ExtensionURIAction(String string) {
                    super("[popup:" + string + "]");
                }
            }
            this.add((IAction)new ExtensionURIAction(id));
        }
        this.addSeparator(GROUP_TOP);
        this.addSeparator(GROUP_VIEWER_SETUP);
        this.addSeparator(GROUP_NEW);
        this.addSeparator(GROUP_OPEN);
        this.addSeparator(GROUP_EDIT);
        this.addSeparator(GROUP_ADDITIONS);
        this.addSeparator(GROUP_PROPETIES);
    }

    private void addSeparator(String separatorId) {
        if (Debug.isDebug()) {
            this.add((IContributionItem)new Separator("dummy"));
            this.add((IAction)new DebugSeparatorAction(separatorId));
            this.add((IContributionItem)new GroupMarker(separatorId));
        } else {
            this.add((IContributionItem)new Separator(separatorId));
        }
    }

    class DebugSeparatorAction
    extends Action {
        DebugSeparatorAction(String text) {
            super("[" + text + "]");
        }
    }
}

