/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage.internal;

import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionGroup;
import com.jrockit.mc.core.formpage.FormPageContributionItem;
import com.jrockit.mc.core.formpage.internal.AbstractSelectorPart;
import com.jrockit.mc.core.formpage.internal.FormPageContributionToolkit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TreeSelectorPart
extends AbstractSelectorPart {
    private List<FormPageContribution> m_rooNodes = new ArrayList<FormPageContribution>();
    private TreeViewer m_viewer;

    public void createPartControl(FormToolkit tooolkit, Composite parent) {
        this.m_viewer = new TreeViewer(parent);
        this.initViewer((StructuredViewer)this.m_viewer);
    }

    protected void initViewer(StructuredViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new FormPageContributionLabelProvider());
        viewer.setContentProvider((IContentProvider)new FormPageContributionProvider());
        viewer.setInput(this.m_rooNodes);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    TreeSelectorPart.this.fireSelectionChanged();
                }
            }
        });
        if (!this.m_rooNodes.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)this.m_rooNodes.get(0)));
        }
    }

    public Control getPartControl() {
        return this.m_viewer == null ? null : this.m_viewer.getControl();
    }

    public ISelection getSelection() {
        if (this.m_viewer != null && !this.m_viewer.getControl().isDisposed()) {
            return this.m_viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        List<FormPageContribution> items;
        this.m_rooNodes = TreeSelectorPart.getSelectionAsFormPageContributionList(selection);
        if (!(this.m_viewer == null || this.m_viewer.getControl().isDisposed() || this.m_rooNodes.isEmpty() || (items = FormPageContributionToolkit.flatten(this.m_rooNodes, FormPageContributionItem.class, Integer.MAX_VALUE, true)).isEmpty())) {
            this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)items.get(0)));
        }
        this.fireSelectionChanged();
    }

    private static class FormPageContributionLabelProvider
    extends LabelProvider {
        private FormPageContributionLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((FormPageContribution)element).getIcon();
        }

        public String getText(Object element) {
            return ((FormPageContribution)element).getLabel();
        }
    }

    private static class FormPageContributionProvider
    implements ITreeContentProvider {
        private FormPageContributionProvider() {
        }

        private FormPageContributionGroup getFormPageContributionGroup(Object object) {
            return (FormPageContributionGroup)(object instanceof FormPageContributionGroup ? object : null);
        }

        public Object[] getChildren(Object parentElement) {
            FormPageContributionGroup group = this.getFormPageContributionGroup(parentElement);
            return group == null ? new Object[]{} : group.getChildren().toArray(new FormPageContribution[0]);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            FormPageContributionGroup group = this.getFormPageContributionGroup(element);
            return group == null ? false : !group.getChildren().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)inputElement;
            return list.toArray(new FormPageContribution[list.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

