/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionGroup;
import com.jrockit.mc.core.formpage.internal.AbstractSelectorPart;
import com.jrockit.mc.core.formpage.internal.FormPageContributionToolkit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ToolbarPart
extends AbstractSelectorPart {
    private final String TOOLBAR_PART_WIDGET_KEY = "TOOLBAR_PART_WIDGET_KEY";
    private Composite m_container;
    private List<FormPageContributionGroup> m_topLevelGroups = new ArrayList<FormPageContributionGroup>();
    private FormPageContributionGroup m_activeGroup;

    public void createPartControl(FormToolkit toolkit, Composite parent) {
        this.m_container = toolkit.createComposite(parent);
        for (FormPageContributionGroup group : this.m_topLevelGroups) {
            Control button = this.createHorizontalButton(toolkit, this.m_container, group);
            button.setLayoutData((Object)this.createGridData());
        }
        this.m_container.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        this.m_container.setLayout((Layout)this.createLayout());
        this.selectDefaultGroup();
    }

    public Control getPartControl() {
        return this.m_container;
    }

    private GridData createGridData() {
        GridData gd = new GridData(0x1000000, 1024, true, false);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = 72;
        return gd;
    }

    private GridLayout createLayout() {
        GridLayout layout = new GridLayout();
        layout.marginLeft = this.isVertical() ? 0 : 2;
        layout.marginRight = this.isVertical() ? 0 : 2;
        layout.horizontalSpacing = 1;
        layout.marginTop = !this.isVertical() ? 30 : 2;
        layout.marginBottom = 0;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = this.isVertical() ? 100 : 1;
        return layout;
    }

    protected Image getIconForContribution(FormPageContributionGroup groupItem) {
        Image image = groupItem.getIcon();
        if (image == null) {
            return CorePlugin.getDefault().getImage("error_obj.gif");
        }
        return image;
    }

    public FormText createFormText(FormToolkit toolkit, Composite parent, boolean trackFocus) {
        FormText engine = new FormText(parent, 0x40040 | Window.getDefaultOrientation());
        engine.marginWidth = 1;
        engine.marginHeight = 0;
        engine.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        toolkit.adapt((Control)engine, trackFocus, true);
        engine.setMenu(parent.getMenu());
        return engine;
    }

    protected Control createHorizontalButton(FormToolkit toolkit, Composite container, FormPageContributionGroup formPageContribution) {
        FormText formText = this.createFormText(toolkit, container, false);
        formText.setText(this.createFormTextHTML(formPageContribution.getLabel()), true, false);
        formText.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        formText.setForeground(toolkit.getHyperlinkGroup().getForeground());
        Image image = this.getIconForContribution(formPageContribution);
        if (image != null) {
            formText.setImage("image", image);
        }
        formText.addHyperlinkListener((IHyperlinkListener)new ToolbarSelectionHandler(this, formPageContribution));
        formText.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        formText.getHyperlinkSettings().setHyperlinkUnderlineMode(2);
        this.setWidgetForFormPageGroup(formPageContribution, (Composite)formText);
        return formText;
    }

    protected Composite getWidgetForFormPageGroup(FormPageContribution group) {
        return (Composite)group.getData("TOOLBAR_PART_WIDGET_KEY");
    }

    protected void setWidgetForFormPageGroup(FormPageContribution group, Composite composite) {
        group.setData("TOOLBAR_PART_WIDGET_KEY", composite);
    }

    private String createFormTextHTML(String name) {
        return "<form><p><a href='dummy'><img href='image'/></a></p><p>\u00a0\u00a0\u00a0\u00a0<a href='dummy'>" + name + "</a></p></form>";
    }

    private boolean isVertical() {
        return this.getStyle() == 2;
    }

    private void selectDefaultGroup() {
        if (!this.m_topLevelGroups.isEmpty()) {
            this.setActiveGroup(this.m_topLevelGroups.iterator().next());
        }
    }

    private void setActiveGroup(FormPageContributionGroup group) {
        if (group != this.m_activeGroup && this.m_container != null && !this.m_container.isDisposed()) {
            for (FormPageContribution formPageContribution : this.m_topLevelGroups) {
                FormText text = (FormText)this.getWidgetForFormPageGroup(formPageContribution);
                if (text == null || text.isDisposed()) continue;
                if (group == formPageContribution) {
                    text.setFont(CorePlugin.getDefault().getFontColorToolkit().getStandardBoldFont());
                    continue;
                }
                text.setFont(JFaceResources.getDefaultFont());
            }
            this.m_activeGroup = group;
            this.fireSelectionChanged();
        }
    }

    public void setSelection(ISelection selection) {
        this.m_topLevelGroups = FormPageContributionToolkit.transformToTwoLevels(ToolbarPart.getSelectionAsFormPageContributionList(selection));
        this.selectDefaultGroup();
    }

    public ISelection getSelection() {
        if (this.m_activeGroup != null) {
            return new StructuredSelection(this.m_activeGroup.getChildren());
        }
        return StructuredSelection.EMPTY;
    }

    private static class ToolbarSelectionHandler
    implements IHyperlinkListener {
        private final FormPageContributionGroup m_formPageGroup;
        private final ToolbarPart m_toolbarPart;

        public ToolbarSelectionHandler(ToolbarPart toolbarPart, FormPageContributionGroup formPageGroup) {
            this.m_formPageGroup = formPageGroup;
            this.m_toolbarPart = toolbarPart;
        }

        private void select(Display display) {
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        ToolbarSelectionHandler.this.m_toolbarPart.setActiveGroup(ToolbarSelectionHandler.this.m_formPageGroup);
                    }
                });
            }
        }

        public void linkActivated(HyperlinkEvent e) {
            this.select(e.widget.getDisplay());
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }
    }
}

