/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionItem;
import com.jrockit.mc.core.formpage.IFormPageSelectorPart;
import com.jrockit.mc.core.formpage.internal.AbstractSelectorPart;
import com.jrockit.mc.core.formpage.internal.EmptySelectorPart;
import com.jrockit.mc.core.formpage.internal.FormPageContributionToolkit;
import com.jrockit.mc.core.formpage.internal.MCFormEditor;
import com.jrockit.mc.core.idesupport.StandardPerspective;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ToolbarFormEditor
extends MCFormEditor {
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    private String m_navigatorPosition = "left";
    private String m_tabPosition = "bottom";
    private IFormPageSelectorPart m_selectorPart = new EmptySelectorPart();
    private List m_selectedItems = Collections.emptyList();
    private Map<Collection<FormPageContributionItem>, FormPageContribution> m_activeAmongSelectedMap = new HashMap<Collection<FormPageContributionItem>, FormPageContribution>();
    private boolean m_visibleSelector = true;
    private Composite m_tabParent;
    private GridData m_toolbarLayoutData;

    public int addPage(IFormPage page) throws PartInitException {
        throw new AddPageNotSupportedException();
    }

    public void addPage(int index, IFormPage page) throws PartInitException {
        throw new AddPageNotSupportedException();
    }

    public void setFocus() {
        if (this.isToolbarVisible()) {
            this.getSelectorPart().getPartControl().setFocus();
        } else {
            this.getContainer().setFocus();
        }
    }

    public int addPage(Control control) {
        throw new AddPageNotSupportedException();
    }

    public void addPage(int index, Control control) {
        throw new AddPageNotSupportedException();
    }

    public int addPage(IEditorPart editor, IEditorInput input) {
        throw new AddPageNotSupportedException();
    }

    public void addPage(int index, IEditorPart editor, IEditorInput input) {
        throw new AddPageNotSupportedException();
    }

    public final void addPages() {
        throw new AddPageNotSupportedException();
    }

    protected int getAbsolutPageIndex(FormPageContributionItem item) {
        int index = 0;
        while (index < this.pages.size()) {
            if (this.pages.get(index) == item.getFormPage()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected abstract void initializeFormPageContributions();

    public void addFormPageContributionItem(FormPageContributionItem item, IEditorInput editorInput) throws PartInitException {
        int index = this.pages.size();
        this.addPageSafe(index, item.getFormPage(), this.getEditorInput());
        this.setPageImage(index, item.getIcon());
        this.setPageText(index, item.getLabel());
        ScrolledForm form = item.getFormPage().getManagedForm().getForm();
        form.setText(item.getLabel());
        form.setImage(item.getIcon());
    }

    private void addPageSafe(int index, IFormPage page, IEditorInput editorInput) {
        try {
            super.addPage(index, (IEditorPart)page, editorInput);
        }
        catch (PartInitException e) {
            CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not add a FormPageContribution of class " + page.getClass().getName() + ". Page will be removed.", e);
        }
    }

    protected void configurePage(int index, IFormPage page) throws PartInitException {
        this.setPageText(index, page.getTitle());
        page.setIndex(index);
        this.registerPage(index, page);
    }

    private void registerPage(int index, Object page) throws PartInitException {
        if (!this.pages.contains(page)) {
            if (index == -1) {
                this.pages.add(page);
            } else {
                this.pages.add(index, page);
            }
        }
    }

    public void dispose() {
        IFormPage[] formPages = this.pages.toArray(new IFormPage[0]);
        int n = 0;
        while (n < formPages.length) {
            this.disposeSite(formPages[n].getSite());
            try {
                formPages[n].dispose();
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.WARNING, "Could not dispose form page!", e);
            }
            ++n;
        }
        if (this.getToolkit() != null) {
            this.getToolkit().dispose();
        }
        this.m_activeAmongSelectedMap.clear();
        this.m_selectedItems = null;
        this.m_selectorPart = null;
        this.updateClosedWithEditor();
    }

    private void updateClosedWithEditor() {
        IWorkbenchPage p = this.getSite().getWorkbenchWindow().getActivePage();
        StandardPerspective.setClosedWithEditor(p == null);
    }

    protected void disposeSite(final IWorkbenchPartSite site) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                if (site instanceof MultiPageEditorSite) {
                    ((MultiPageEditorSite)site).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    protected void setPageText(int pageIndex, String text) {
        this.getMultiPageItem(pageIndex).setText(text == null ? "" : text);
    }

    private CTabItem createMultiPageItem(int index, Control control, String title, Image image) {
        CTabItem item = new CTabItem(this.getMultiPageTabFolder(), 0, index);
        item.setControl(control);
        item.setText(title == null ? "" : title);
        item.setImage(image);
        return item;
    }

    private void setMultiPageActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getMultiPageTabFolder().setSelection(pageIndex);
        this.pageChange(pageIndex);
    }

    private void removeMultiPageItem(int pageIndex) {
        CTabItem item = this.getMultiPageItem(pageIndex);
        item.dispose();
    }

    private CTabItem getMultiPageItem(int pageIndex) {
        return this.getMultiPageTabFolder().getItem(pageIndex);
    }

    private CTabFolder getMultiPageTabFolder() {
        return (CTabFolder)this.getContainer();
    }

    protected void createPages() {
        if (TOP.equals(this.getTabPosition())) {
            try {
                Field f = MultiPageEditorPart.class.getDeclaredField("container");
                f.setAccessible(true);
                Composite container = (Composite)f.get((Object)this);
                container.dispose();
                container = this.createTopContainer(this.m_tabParent, 0x800080);
                f.set((Object)this, container);
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().warning("Could not access CTabFolder using reflection. Will use default CTabFolder at bottom.");
            }
        }
        this.createFormPageContributionItems();
    }

    private String getTabPosition() {
        return this.m_tabPosition;
    }

    private CTabFolder createTopContainer(Composite parent, int style) {
        parent.setLayout((Layout)new FillLayout());
        final CTabFolder newContainer = new CTabFolder(parent, style);
        newContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = newContainer.indexOf((CTabItem)e.item);
                ToolbarFormEditor.this.pageChange(newPageIndex);
            }
        });
        return newContainer;
    }

    protected Composite createPageContainer(Composite parent) {
        Composite container = super.createPageContainer(parent);
        if (LEFT.equals(this.getNavigatorPosition()) || TOP.equals(this.getNavigatorPosition())) {
            this.createSelector(container);
            this.createSash(parent);
            this.m_tabParent = this.createMain(parent);
        }
        if (RIGHT.equals(this.getNavigatorPosition()) || BOTTOM.equals(this.getNavigatorPosition())) {
            this.m_tabParent = this.createMain(parent);
            this.createSash(parent);
            this.createSelector(container);
        }
        container.setLayout((Layout)this.createPageContainerLayout());
        return this.m_tabParent;
    }

    private void createSash(Composite parent) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        if (this.isVertical()) {
            gd.heightHint = 1;
            gd.grabExcessHorizontalSpace = true;
        } else {
            gd.widthHint = 1;
            gd.grabExcessVerticalSpace = true;
        }
        Composite sash = new Composite(parent, 0);
        sash.setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
        sash.setLayoutData((Object)gd);
    }

    private GridLayout createPageContainerLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.isVertical() ? 1 : 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }

    boolean isVertical() {
        return this.getNavigatorPosition().equals(TOP) || this.getNavigatorPosition().equals(BOTTOM);
    }

    private Composite createMain(Composite parent) {
        GridData gd2 = new GridData(4, 4, true, true);
        Composite main = this.getToolkit().createComposite(parent);
        main.setLayoutData((Object)gd2);
        return main;
    }

    public void setSelector(IFormPageSelectorPart selector) {
        this.m_selectorPart = selector;
    }

    private void createSelector(Composite container) {
        this.m_selectorPart.setStyle(this.isVertical() ? 2 : 1);
        this.m_selectorPart.createPartControl(this.getToolkit(), container);
        this.m_toolbarLayoutData = new GridData(4, 4, this.isVertical(), !this.isVertical());
        this.m_toolbarLayoutData.exclude = !this.isSelectorVisible();
        this.m_selectorPart.getPartControl().setLayoutData((Object)this.m_toolbarLayoutData);
        this.m_selectorPart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ToolbarFormEditor.this.show(event.getSelection(), false);
            }
        });
        this.m_selectedItems = AbstractSelectorPart.getSelectionAsFormPageContributionList(this.m_selectorPart.getSelection());
    }

    private boolean isSelectorVisible() {
        return this.m_visibleSelector;
    }

    public void show(ISelection selection, boolean forceUpdate) {
        IStructuredSelection is;
        List<FormPageContribution> formPageContributionItems;
        if (selection instanceof IStructuredSelection && this.getContainer() != null && (!(formPageContributionItems = FormPageContributionToolkit.flatten((is = (IStructuredSelection)selection).toList(), FormPageContributionItem.class, Integer.MAX_VALUE, true)).equals(this.getSelectedItems()) || forceUpdate)) {
            this.storeActiveContributionItem(this.getSelectedItems(), this.getActiveContributionItem());
            int oldPageCount = this.getPageCount();
            FormPageContributionItem activeItem = this.getActiveContributionItem(formPageContributionItems);
            int index = 0;
            int activeInGroupLastTime = 0;
            for (FormPageContributionItem formPageContributionItem : formPageContributionItems) {
                IFormPage info;
                if (formPageContributionItem == activeItem) {
                    activeInGroupLastTime = index;
                }
                if ((info = formPageContributionItem.getFormPage()).getPartControl() == null) {
                    throw new IllegalStateException("You can't call show before the contributions has been initialized.");
                }
                this.createMultiPageItem(oldPageCount + index, (Control)info.getPartControl().getParent(), formPageContributionItem.getLabel(), formPageContributionItem.getIcon());
                this.setPageText(oldPageCount + index, formPageContributionItem.getLabel());
                ++index;
            }
            int currentActive = super.getActivePage();
            boolean bl = false;
            int n = 0;
            while (n < oldPageCount) {
                boolean bl2;
                if (n != currentActive) {
                    this.removeMultiPageItem(bl2 ? 1 : 0);
                } else {
                    bl2 = true;
                }
                ++n;
            }
            this.setSelectedItems(formPageContributionItems);
            if (currentActive != -1) {
                this.removeMultiPageItem(0);
            }
            this.setActivePage(this.getPageIndexFromTabIndex(activeInGroupLastTime));
        }
    }

    private FormPageContributionItem getActiveContributionItem() {
        int selectedIndex = this.getMultiPageTabFolder().getSelectionIndex();
        if (selectedIndex >= 0 && selectedIndex < this.getMultiPageTabFolder().getItemCount() && selectedIndex < this.m_selectedItems.size()) {
            return (FormPageContributionItem)this.m_selectedItems.get(selectedIndex);
        }
        return null;
    }

    private void setSelectedItems(List formPageContributionItems) {
        this.m_selectedItems = formPageContributionItems;
    }

    private List getSelectedItems() {
        return this.m_selectedItems;
    }

    private void storeActiveContributionItem(Collection<FormPageContributionItem> formPageContributionItems, FormPageContributionItem item) {
        if (this.m_activeAmongSelectedMap.size() > 15) {
            this.m_activeAmongSelectedMap.remove(this.m_activeAmongSelectedMap.keySet().iterator().next());
        }
        this.m_activeAmongSelectedMap.put(formPageContributionItems, item);
    }

    private FormPageContributionItem getActiveContributionItem(Collection formPageContributionItems) {
        FormPageContributionItem item = (FormPageContributionItem)this.m_activeAmongSelectedMap.get(formPageContributionItems);
        if (item == null && !formPageContributionItems.isEmpty()) {
            return (FormPageContributionItem)formPageContributionItems.iterator().next();
        }
        return item;
    }

    public void setSelectorVisible(boolean visible) {
        if (this.m_toolbarLayoutData != null) {
            this.m_toolbarLayoutData.exclude = !visible;
            this.getContainer().getParent().getParent().layout(true, true);
        }
        this.m_visibleSelector = visible;
    }

    public boolean isToolbarVisible() {
        return !this.m_toolbarLayoutData.exclude;
    }

    protected void setTabPosition(String position) {
        if (TOP.equals(position) || BOTTOM.equals(position)) {
            this.m_tabPosition = position;
        }
    }

    protected IFormPageSelectorPart getSelectorPart() {
        return this.m_selectorPart;
    }

    protected void setNavigatorPosition(String position) {
        if (TOP.equals(position) || BOTTOM.equals(position) || LEFT.equals(position) || RIGHT.equals(position)) {
            this.m_navigatorPosition = position;
        }
    }

    private String getNavigatorPosition() {
        return this.m_navigatorPosition;
    }

    protected final void createFormPageContributionItems() {
        this.initializeFormPageContributions();
        this.getToolkit().adapt((Composite)this.getMultiPageTabFolder());
        this.getMultiPageTabFolder().setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
    }

    private int getTabIndexFromPageIndex(int pageIndex) {
        int index = 0;
        IFormPage fp = (IFormPage)this.pages.get(pageIndex);
        for (FormPageContributionItem fpg : this.m_selectedItems) {
            if (fpg.getFormPage() == fp) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private int getPageIndexFromTabIndex(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.m_selectedItems.size()) {
            if (this.m_selectedItems.isEmpty()) {
                return 0;
            }
            IFormPage fpg = ((FormPageContributionItem)this.m_selectedItems.get(tabIndex)).getFormPage();
            int index = 0;
            while (index < this.pages.size()) {
                if (this.pages.get(index) == fpg) {
                    return index;
                }
                ++index;
            }
        }
        return 0;
    }

    protected void setActivePage(int pageIndex) {
        if (this.pages.size() > pageIndex && this.pages.get(pageIndex) instanceof IFormPage) {
            this.pageChange(this.getTabIndexFromPageIndex(pageIndex));
            IFormPage activePage = (IFormPage)this.pages.get(pageIndex);
            activePage.setActive(true);
        }
        this.setMultiPageActivePage(this.getTabIndexFromPageIndex(pageIndex));
        this.updateActionBarContributor(pageIndex);
    }

    private void updatePageIndices() {
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                IFormPage fpage = (IFormPage)page;
                fpage.setIndex(i);
            }
            ++i;
        }
    }

    public void removePage(int pageIndex) {
        IFormPage fpage = (IFormPage)this.pages.get(pageIndex);
        fpage.dispose();
        this.pages.remove(pageIndex);
        this.updatePageIndices();
    }

    public void removeMultiPage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getEditor(pageIndex);
        CTabItem item = this.getMultiPageItem(pageIndex);
        Control pageControl = item.getControl();
        item.dispose();
        if (pageControl != null) {
            pageControl.dispose();
        }
    }

    public final int getActivePage() {
        return this.getPageIndexFromTabIndex(super.getActivePage());
    }

    protected final IEditorPart getEditor(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            return pageIndex < this.pages.size() ? (IEditorPart)this.pages.get(pageIndex) : null;
        }
        return null;
    }

    protected final void pageChange(int tabIndex) {
        int result = this.getPageIndexFromTabIndex(tabIndex);
        if (result != -1) {
            super.pageChange(result);
        }
    }

    public void updateSelectedItems() {
        this.show(this.getSelectorPart().getSelection(), true);
    }

    private static final class AddPageNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = -6808162764192677901L;

        public AddPageNotSupportedException() {
            super("AddPage not supported. Use addCategory and addCategoryPage instead.");
        }
    }
}

