/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.internal.Messages;
import com.jrockit.mc.core.misc.WorkbenchPartPropertySheets;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class MCFormEditor
extends FormEditor
implements ISaveablePart2 {
    private PageChangeListener m_propertySheetPageChangeListener;

    public boolean isSaveOnCloseNeeded() {
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            IFormPage page = (IFormPage)this.pages.get(i);
            if (page.isSaveOnCloseNeeded()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDirty() {
        int count = this.getPageCount();
        int i = 0;
        while (i < count) {
            if (((IFormPage)this.pages.get(i)).isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            int totalWork = this.getSaveablePageCount();
            if (totalWork > 0) {
                monitor.beginTask(MessageFormat.format(Messages.SAVING_X_NUMBER_OF_PARTS0, this.getTitle()), totalWork);
                this.doSavePages(monitor, totalWork);
                this.firePropertyChange(257);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void doSavePages(IProgressMonitor monitor, int totalWork) {
        monitor.worked(1);
        int i = 0;
        while (i < this.pages.size()) {
            this.doSavePage(monitor, (IFormPage)this.pages.get(i));
            ++i;
        }
    }

    protected void doSavePage(IProgressMonitor monitor, IFormPage page) {
        if (page.isSaveOnCloseNeeded()) {
            monitor.subTask(MessageFormat.format(Messages.MCFormEditor_SAVEING_PAGE_X, page.getTitle()));
            page.doSave((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
        }
    }

    private int getSaveablePageCount() {
        int totalWork = 0;
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage page = (IFormPage)this.pages.get(i);
            if (page.isSaveOnCloseNeeded()) {
                ++totalWork;
            }
            ++i;
        }
        return totalWork;
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(CorePlugin.getDefault().getFormColors(display));
    }

    public void restoreState(IMemento memento) {
        int n = 0;
        while (n < this.pages.size()) {
            if (this.pages.get(n) instanceof IPersistableEditor) {
                ((IPersistableEditor)this.pages.get(n)).restoreState(memento);
            }
            ++n;
        }
    }

    public void saveState(IMemento memento) {
        int n = 0;
        while (n < this.pages.size()) {
            if (this.pages.get(n) instanceof IPersistableEditor) {
                ((IPersistableEditor)this.pages.get(n)).saveState(memento);
            }
            ++n;
        }
    }

    protected final WorkbenchPartPropertySheets createWorkBenchPropertySheets() {
        this.cleanUpPageChangeListener();
        IFormPage p = this.getActivePageInstance();
        WorkbenchPartPropertySheets workBenchPropertySheets = new WorkbenchPartPropertySheets(this.pages, (IWorkbenchPart)p);
        this.m_propertySheetPageChangeListener = new PageChangeListener(workBenchPropertySheets);
        this.addPageChangedListener(this.m_propertySheetPageChangeListener);
        return workBenchPropertySheets;
    }

    protected final void cleanUpPageChangeListener() {
        if (this.m_propertySheetPageChangeListener != null) {
            this.removePageChangedListener(this.m_propertySheetPageChangeListener);
            this.m_propertySheetPageChangeListener = null;
        }
    }

    private static class PageChangeListener
    implements IPageChangedListener {
        private final WorkbenchPartPropertySheets m_page;

        PageChangeListener(WorkbenchPartPropertySheets mpage) {
            this.m_page = mpage;
        }

        public void pageChanged(PageChangedEvent event) {
            if (event.getSelectedPage() instanceof IWorkbenchPart) {
                this.m_page.setActivePart((IWorkbenchPart)event.getSelectedPage());
            }
        }
    }
}

