/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionGroup;
import com.jrockit.mc.core.formpage.FormPageContributionItem;
import com.jrockit.mc.core.formpage.internal.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormPageContributionToolkit {
    public static final String OTHER_ID = "com.jrockit.mc.core.ui.formpages.group.other";
    private static final String ACCESSIBILITY_GROUP_NAME_FORMAT = "{0} - {1}";

    public static void initializeContributionsWithEditor(List rootNodes, FormEditor formeditor) {
        for (FormPageContribution fpc : rootNodes) {
            if (fpc instanceof FormPageContributionItem) {
                FormPageContributionItem item = (FormPageContributionItem)fpc;
                try {
                    item.getFormPage().initialize(formeditor);
                }
                catch (Exception e) {
                    CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not initialize FormPage with label " + item.getLabel() + ". Will be setinvsible.", e);
                    item.setVisible(Boolean.FALSE);
                }
            }
            if (!(fpc instanceof FormPageContributionGroup)) continue;
            FormPageContributionGroup group = (FormPageContributionGroup)fpc;
            FormPageContributionToolkit.initializeContributionsWithEditor(group.getChildren(), formeditor);
        }
    }

    public static List<FormPageContribution> flatten(Collection<FormPageContribution> rootNodes, Class<? extends FormPageContribution> assignableFromClass, int depth, boolean onlyVisible) {
        ArrayList<FormPageContribution> list = new ArrayList<FormPageContribution>();
        if (depth >= 0) {
            for (FormPageContribution fpc : rootNodes) {
                if (fpc.getClass().isAssignableFrom(assignableFromClass) && (!onlyVisible || Boolean.TRUE.equals(fpc.getVisible()))) {
                    list.add(fpc);
                }
                if (!(fpc instanceof FormPageContributionGroup)) continue;
                FormPageContributionGroup group = (FormPageContributionGroup)fpc;
                if (onlyVisible && !Boolean.TRUE.equals(group.getVisible())) continue;
                list.addAll(FormPageContributionToolkit.flatten(group.getChildren(), assignableFromClass, depth - 1, onlyVisible));
            }
        }
        return list;
    }

    public static List<FormPageContributionGroup> transformToTwoLevels(List<FormPageContribution> rootContributions) {
        List<FormPageContribution> allTopLevelCategories = FormPageContributionToolkit.flatten(rootContributions, FormPageContributionGroup.class, 0, true);
        List<FormPageContribution> noGroupsItems = FormPageContributionToolkit.flatten(rootContributions, FormPageContributionItem.class, 0, true);
        ArrayList<FormPageContributionGroup> formPageContributions = new ArrayList<FormPageContributionGroup>();
        for (FormPageContributionGroup formPageContributionGroup : allTopLevelCategories) {
            List<FormPageContribution> allValidChidrenItems = FormPageContributionToolkit.flatten(formPageContributionGroup.getChildren(), FormPageContributionItem.class, Integer.MAX_VALUE, true);
            if (allValidChidrenItems.isEmpty() || !Boolean.TRUE.equals(formPageContributionGroup.getVisible())) continue;
            formPageContributions.add(formPageContributionGroup);
            formPageContributionGroup.clear();
            formPageContributionGroup.addAll(allValidChidrenItems);
        }
        if (!noGroupsItems.isEmpty()) {
            FormPageContributionGroup groupForUnGrouped = new FormPageContributionGroup();
            groupForUnGrouped.addAll(noGroupsItems);
            groupForUnGrouped.setLabel(Messages.FormPageContributionToolkit_OTHER_GROUP_TEXT);
            groupForUnGrouped.setId(OTHER_ID);
            groupForUnGrouped.setIcon(CorePlugin.getDefault().getImage("clock16.gif"), false);
            formPageContributions.add(groupForUnGrouped);
        }
        return formPageContributions;
    }

    public static void prettyPrint(List rootContributions, String indent) {
        for (FormPageContribution fpc : rootContributions) {
            FormPageContribution f;
            if (fpc instanceof FormPageContributionGroup) {
                f = (FormPageContributionGroup)fpc;
                System.out.println("*" + f.getLabel());
                FormPageContributionToolkit.prettyPrint(((FormPageContributionGroup)f).getChildren(), String.valueOf(indent) + "    ");
            }
            if (!(fpc instanceof FormPageContributionItem)) continue;
            f = (FormPageContributionItem)fpc;
            System.out.println(String.valueOf(indent) + f.getLabel());
        }
    }

    public static void disposeFormPageContributions(List items) {
        for (FormPageContribution item : items) {
            if (item instanceof FormPageContributionGroup) {
                FormPageContributionGroup group = (FormPageContributionGroup)item;
                FormPageContributionToolkit.disposeFormPageContributions(group.getChildren());
            }
            item.dispose();
        }
    }

    public static List<FormPageContribution> flattenButPreserveGroupNames(List<FormPageContribution> selectionAsList) {
        ArrayList<FormPageContribution> newFlattenedList = new ArrayList<FormPageContribution>();
        List<FormPageContributionGroup> twoLevels = FormPageContributionToolkit.transformToTwoLevels(selectionAsList);
        for (FormPageContribution formPageContribution : twoLevels) {
            if (formPageContribution instanceof FormPageContributionGroup) {
                FormPageContributionGroup group = (FormPageContributionGroup)formPageContribution;
                for (FormPageContributionItem formPageContributionItem : group.getChildren()) {
                    FormPageContributionToolkit.setTitleWithGroupName(formPageContribution.getLabel(), formPageContributionItem);
                    newFlattenedList.add(formPageContributionItem);
                }
            }
            if (!(formPageContribution instanceof FormPageContributionItem)) continue;
            FormPageContributionToolkit.setTitleWithGroupName(Messages.FormPageContributionToolkit_UNKNOWN_TAB_GROUP_NAME_TEXT, (FormPageContributionItem)formPageContribution);
            newFlattenedList.add(formPageContribution);
        }
        return newFlattenedList;
    }

    private static void setTitleWithGroupName(String groupName, FormPageContributionItem item) {
        item.setLabel(NLS.bind((String)ACCESSIBILITY_GROUP_NAME_FORMAT, (Object)groupName, (Object)item.getLabel()));
    }
}

