/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionGroup;
import com.jrockit.mc.core.formpage.internal.AbstractSelectorPart;
import com.jrockit.mc.core.formpage.internal.FormPageContributionToolkit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ButtonToolbarSelector
extends AbstractSelectorPart {
    private static final int VERTICAL_PAD = 30;
    private static final int HORIZONTAL_TOP = 2;
    private final String TOOLBAR_PART_WIDGET_KEY = "TOOLBAR_PART_WIDGET_KEY";
    private Composite m_container;
    private List m_topLevelGroups = new ArrayList();
    private FormPageContributionGroup m_activeGroup;
    private ToolBar m_toolbar;
    private Point m_toolbarLargeSize;
    private FormToolkit m_toolkit;
    private boolean m_large = true;

    public void createPartControl(FormToolkit toolkit, Composite parent) {
        this.m_container = toolkit.createComposite(parent);
        this.m_toolkit = toolkit;
        this.m_toolbar = this.createToolbar(toolkit);
        this.m_toolbarLargeSize = this.calculateToolBarSize(this.m_toolbar);
        this.m_activeGroup = this.m_topLevelGroups.size() > 0 ? this.m_topLevelGroups.get(0) : null;
        this.m_container.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        this.m_container.setLayout((Layout)this.createLayout());
        this.hookResizeListener();
        this.selectDefaultGroup();
    }

    private Point calculateToolBarSize(ToolBar mToolbar) {
        return this.m_toolbar.computeSize(-1, -1);
    }

    private void hookResizeListener() {
        this.m_container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ButtonToolbarSelector.this.updateToolbar();
            }
        });
    }

    private void updateToolbar() {
        boolean large = this.isLarge();
        if (large != this.m_large) {
            this.m_toolbar.dispose();
            this.m_large = large;
            this.m_toolbar = this.createToolbar(this.m_toolkit);
        }
    }

    private boolean isLarge() {
        Rectangle containerArea = this.m_container.getClientArea();
        if (this.isVertical()) {
            return this.m_toolbarLargeSize.x < containerArea.width - 2;
        }
        return this.m_toolbarLargeSize.y + 25 + 60 < containerArea.height;
    }

    private ToolBar createToolbar(FormToolkit toolkit) {
        ToolBar tb = new ToolBar(this.m_container, 0x800400 | (this.isVertical() ? 256 : 512));
        for (FormPageContributionGroup group : this.m_topLevelGroups) {
            this.createHorizontalButton(toolkit, (Composite)tb, group);
        }
        tb.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        tb.setLayoutData((Object)this.createGridData());
        return tb;
    }

    public Control getPartControl() {
        return this.m_container;
    }

    private GridData createGridData() {
        GridData gd = new GridData(4, 4, this.isVertical(), !this.isVertical());
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        gd.minimumWidth = this.isVertical() ? 512 : 72;
        return gd;
    }

    private GridLayout createLayout() {
        GridLayout layout = new GridLayout();
        layout.marginLeft = this.isVertical() ? 2 : 0;
        layout.marginRight = this.isVertical() ? 0 : 0;
        layout.horizontalSpacing = 1;
        layout.marginTop = !this.isVertical() ? 30 : 2;
        layout.marginBottom = !this.isVertical() ? 30 : 2;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = this.isVertical() ? 100 : 1;
        return layout;
    }

    protected Image getIconForContribution(FormPageContributionGroup groupItem) {
        Image image;
        Image image2 = image = this.m_large ? groupItem.getLargeIcon() : groupItem.getIcon();
        if (image == null) {
            return CorePlugin.getDefault().getImage("error_obj.gif");
        }
        return image;
    }

    public FormText createFormText(FormToolkit toolkit, Composite parent, boolean trackFocus) {
        FormText engine = new FormText(parent, 0x40040 | Window.getDefaultOrientation());
        engine.marginWidth = 1;
        engine.marginHeight = 0;
        engine.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        toolkit.adapt((Control)engine, trackFocus, true);
        engine.setMenu(parent.getMenu());
        return engine;
    }

    protected Control createHorizontalButton(FormToolkit toolkit, Composite container, final FormPageContributionGroup formPageContribution) {
        ToolItem toolItem = new ToolItem((ToolBar)container, 16);
        toolItem.setData("name", (Object)formPageContribution.getId());
        toolItem.setImage(this.getIconForContribution(formPageContribution));
        toolItem.setText(formPageContribution.getLabel());
        if (this.m_activeGroup == formPageContribution) {
            toolItem.setSelection(true);
        }
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ButtonToolbarSelector.this.setActiveGroup(formPageContribution);
            }
        });
        return toolItem.getControl();
    }

    protected Composite getWidgetForFormPageGroup(FormPageContribution group) {
        return (Composite)group.getData("TOOLBAR_PART_WIDGET_KEY");
    }

    protected void setWidgetForFormPageGroup(FormPageContribution group, Composite composite) {
        group.setData("TOOLBAR_PART_WIDGET_KEY", composite);
    }

    private boolean isVertical() {
        return this.getStyle() == 2;
    }

    public void selectDefaultGroup() {
        if (!this.m_topLevelGroups.isEmpty()) {
            this.setActiveGroup((FormPageContributionGroup)this.m_topLevelGroups.iterator().next());
        }
    }

    private void setActiveGroup(FormPageContributionGroup group) {
        if (group != this.m_activeGroup && this.m_container != null && !this.m_container.isDisposed()) {
            this.m_activeGroup = group;
            this.fireSelectionChanged();
        }
    }

    public void setSelection(ISelection selection) {
        this.m_topLevelGroups = FormPageContributionToolkit.transformToTwoLevels(ButtonToolbarSelector.getSelectionAsFormPageContributionList(selection));
        this.selectDefaultGroup();
    }

    public ISelection getSelection() {
        if (this.m_activeGroup != null) {
            return new StructuredSelection(this.m_activeGroup.getChildren());
        }
        return StructuredSelection.EMPTY;
    }
}

