/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.formpage;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.formpage.FormPageContribution;
import com.jrockit.mc.core.formpage.FormPageContributionGroup;
import com.jrockit.mc.core.formpage.FormPageContributionItem;
import com.jrockit.mc.core.formpage.ImageHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormPageContributionFactory {
    private final String FORM_PAGE_COMMAND_PARAMETER_NAME = "formpage";
    private final String FORM_PAGE_ATTRIBUTE_TITLE = "title";
    private final String FORM_PAGE_ATTRIBUTE_TITLE_IMAGE = "icon";
    private final String FORM_PAGE_ATTRIBUTE_EDITOR_ID = "id";
    private final String FORM_PAGE_ATTRIBUTE_COMMAND_EDITOR_ID = "hostEditorId";
    private final String FORM_PAGE_ATTRIBUTE_IFORMPAGE_CLASS = "class";
    private final String EXTENSION_POINT_MAIN_ATTRIBUTE = "formpage";
    private final String EXTENSION_PLUGIN = "com.jrockit.mc.core";
    private final String EXTENSION_POINT = "com.jrockit.mc.core.formpage";
    private final String UNKNOWN_MENU_ID = "unknown.menu.id";
    private final Logger m_logger;
    private final HashMap<String, FormPageContribution> m_contributionMap;
    private final String m_editorId;
    private final IMenuService m_menuService;

    public FormPageContributionFactory(IServiceLocator locator, String editorID) {
        this.m_editorId = editorID;
        this.m_logger = CorePlugin.getDefault().getLogger();
        this.m_contributionMap = new HashMap();
        this.m_menuService = (IMenuService)locator.getService(IMenuService.class);
    }

    private static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        return display == null ? Display.getDefault() : display;
    }

    public List<FormPageContribution> createFormPageContributionsFromMenuContribution(String uri) {
        ArrayList<FormPageContribution> result = new ArrayList<FormPageContribution>();
        this.clearContributions();
        this.addFormPageContributionItems();
        if (uri != null) {
            result.addAll(this.createFormPageContributionHierarchy(uri));
        }
        result.addAll(this.m_contributionMap.values());
        return result;
    }

    private void clearContributions() {
        this.m_contributionMap.clear();
    }

    private void addFormPageContributionItems() {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint exPoint = registry.getExtensionPoint("com.jrockit.mc.core.formpage");
            IExtension[] ext = exPoint.getExtensions();
            int i = 0;
            while (i < ext.length) {
                IConfigurationElement[] element = ext[i].getConfigurationElements();
                int j = 0;
                while (j < element.length) {
                    if (element[j].getName().equalsIgnoreCase("formpage") && this.isEditor(element[j])) {
                        this.addContribution(element[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception iroe) {
            this.getLogger().log(Level.SEVERE, "Error when examining extension point com.jrockit.mc.core.formpage", iroe);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    private boolean isEditor(IConfigurationElement element) {
        return this.m_editorId.equals(element.getAttribute("hostEditorId"));
    }

    private Image createImage(IConfigurationElement configElement, String name) {
        Image image = null;
        try {
            String iconName = configElement.getAttribute("icon");
            if (iconName != null) {
                IExtension extension = configElement.getDeclaringExtension();
                String extendingPluginId = extension.getContributor().getName();
                ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconName);
                image = desc.createImage();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Could not load image for FormPage with label " + name);
        }
        return image;
    }

    private void addContribution(IConfigurationElement formPageelement) {
        try {
            IFormPage page = (IFormPage)formPageelement.createExecutableExtension("class");
            if (page != null) {
                FormPageContributionItem contrib = new FormPageContributionItem(page);
                String formPageId = formPageelement.getAttribute("id");
                if (formPageId != null) {
                    String image = formPageelement.getAttribute("icon");
                    String title = formPageelement.getAttribute("title");
                    contrib.setLabel(title);
                    contrib.setIcon(this.createImage(formPageelement, image), true);
                    contrib.setVisible(Boolean.TRUE);
                    this.m_contributionMap.put(formPageId, contrib);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error when create formPage contribution for extension pointcom.jrockit.mc.core.formpage", e);
        }
    }

    private ParameterizedCommand getParameterizedCommand(CommandContributionItem item) {
        try {
            Method method = item.getClass().getDeclaredMethod("getCommand", new Class[0]);
            method.setAccessible(true);
            ParameterizedCommand pc = (ParameterizedCommand)method.invoke((Object)item, new Object[0]);
            method.setAccessible(false);
            return pc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<FormPageContribution> createFormPageContributionHierarchy(String uriAsString) {
        Shell shell = new Shell(FormPageContributionFactory.getStandardDisplay());
        FormPageContributionGroup root = new FormPageContributionGroup();
        MenuManager manager = new MenuManager("pop", uriAsString);
        this.m_menuService.populateContributionManager((ContributionManager)manager, uriAsString);
        this.iterate(shell, root, manager.getItems(), uriAsString);
        ArrayList<FormPageContribution> list = new ArrayList<FormPageContribution>();
        list.addAll(root.getChildren());
        this.m_menuService.releaseContributions((ContributionManager)manager);
        manager.dispose();
        shell.dispose();
        return list;
    }

    private void iterate(Shell shell, FormPageContributionGroup parent, IContributionItem[] items, String url) {
        int n = 0;
        while (n < items.length) {
            if (items[n] instanceof CommandContributionItem) {
                this.createContributionItem(shell, parent, (CommandContributionItem)items[n]);
            }
            if (items[n] instanceof MenuManager) {
                this.createFormPageContributionGroup(shell, parent, (MenuManager)items[n], url);
            }
            ++n;
        }
    }

    private String getGroupId(MenuManager manager) {
        IContributionItem[] items = manager.getItems();
        if (items.length > 0 && manager.getId() != null) {
            return manager.getId();
        }
        return "unknown.menu.id";
    }

    private void createFormPageContributionGroup(Shell shell, FormPageContributionGroup parent, MenuManager manager, String url) {
        MenuItem item;
        FormPageContributionGroup g = new FormPageContributionGroup();
        parent.add(g);
        this.iterate(shell, g, manager.getItems(), url);
        Menu menu = new Menu((Control)shell);
        manager.fill(menu, 0);
        if (menu.getItemCount() > 0 && (item = menu.getItem(0)) != null) {
            g.setId(this.getGroupId(manager));
            g.setLabel(item.getText());
            g.setEnabled(new Boolean(item.getEnabled()));
            g.setVisible(manager.isVisible());
            g.setEnabled(manager.isEnabled());
        }
    }

    private FormPageContributionItem getFormPageFor(CommandContributionItem contributionItem) {
        ParameterizedCommand pc = this.getParameterizedCommand(contributionItem);
        if (pc != null && pc.getCommand() != null && pc.getParameterMap() != null) {
            Map map = pc.getParameterMap();
            String id = (String)map.get("formpage");
            FormPageContributionItem item = (FormPageContributionItem)this.m_contributionMap.get(id);
            if (item != null) {
                this.m_contributionMap.remove(id);
            }
            return item;
        }
        return null;
    }

    private void createContributionItem(Shell shell, FormPageContributionGroup parent, CommandContributionItem contributionItem) {
        ToolBar toolbar = new ToolBar((Composite)shell, 256);
        contributionItem.fill(toolbar, 0);
        if (toolbar.getItemCount() > 0) {
            ToolItem t = toolbar.getItem(0);
            FormPageContributionItem fpc = this.getFormPageFor(contributionItem);
            if (fpc != null) {
                fpc.setId(contributionItem.getId());
                fpc.setDisabledImage(ImageHandler.cloneImage(t.getDisabledImage()), true);
                fpc.setIcon(ImageHandler.cloneImage(t.getImage()), true);
                fpc.setHoverImage(ImageHandler.cloneImage(t.getHotImage()), true);
                fpc.setTooltip(fpc.getTooltip());
                fpc.setEnabled(new Boolean(t.getEnabled()));
                fpc.setLabel(t.getToolTipText());
                fpc.setVisible(contributionItem.isVisible());
                fpc.setEnabled(contributionItem.isEnabled());
                parent.add(fpc);
            } else {
                this.getLogger().warning("Could not find a formPage for " + t.getToolTipText() + " . Perhaps it's already used by annother command?");
            }
        }
        toolbar.dispose();
    }
}

