/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.dnd;

import com.jrockit.mc.core.dnd.LocalDnDTransfer;
import com.jrockit.mc.core.model.fields.Row;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dnd.IDragAndDropService;

public abstract class DropListener
extends DropTargetAdapter {
    private int m_style;

    public static void addToViewer(StructuredViewer viewer, int style, DropListener listener) {
        listener.setStyle(style);
        DropTarget target = new DropTarget(viewer.getControl(), style);
        target.setTransfer(new Transfer[]{LocalDnDTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)listener);
    }

    public static void addToControl(Control control, int style, DropListener listener) {
        listener.setStyle(style);
        DropTarget target = new DropTarget(control, style);
        target.setTransfer(new Transfer[]{LocalDnDTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)listener);
    }

    public static void addToService(IDragAndDropService service, Control control, int style, DropListener dropListener) {
        service.addMergedDropTarget(control, style, new Transfer[]{LocalDnDTransfer.getTransfer()}, (DropTargetListener)dropListener);
        dropListener.setStyle(style);
    }

    public final void drop(DropTargetEvent event) {
        IStructuredSelection ss = LocalDnDTransfer.getInstance().getStructuredSelection();
        if (this.isValidSelection(ss)) {
            this.drop(ss, this.getSourceObjectFromEvent(event));
        }
        event.detail = 0;
    }

    public final void dragOver(DropTargetEvent event) {
        IStructuredSelection ss = LocalDnDTransfer.getInstance().getStructuredSelection();
        if (this.isValidSelection(ss) && this.isDropable(ss, this.getSourceObjectFromEvent(event))) {
            event.detail = this.m_style;
            return;
        }
        event.detail = 0;
    }

    public abstract void dropAccept(DropTargetEvent var1);

    protected abstract boolean isDropable(IStructuredSelection var1, Object var2);

    protected abstract void drop(IStructuredSelection var1, Object var2);

    private void setStyle(int style) {
        this.m_style = style;
    }

    private Object getSourceObjectFromEvent(DropTargetEvent event) {
        if (event.item != null) {
            Object object = event.item.getData();
            if (object instanceof Row) {
                return ((Row)object).getElement();
            }
            return object;
        }
        return null;
    }

    private boolean isValidSelection(IStructuredSelection ss) {
        return ss != null && !ss.isEmpty();
    }
}

