/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.checkedstate;

import com.jrockit.mc.core.checkedstate.CheckedStateManager;
import com.jrockit.mc.core.checkedstate.ICheckedElement;
import com.jrockit.mc.core.checkedstate.ICheckedStateModifierProvider;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;

public class ContainerProviderModifier
implements ICheckedStateModifierProvider {
    private final Map<Object, ICheckedElement> m_cachedStateMap = new HashMap<Object, ICheckedElement>();
    private final CheckedStateManager m_checkStateManager;

    public ContainerProviderModifier(CheckedStateManager manager) {
        this.m_checkStateManager = manager;
    }

    public void checkStateChanged(CheckboxTreeViewer viewer) {
        this.m_cachedStateMap.clear();
        ITreeContentProvider itcp = this.getTreeContentProvider();
        if (itcp != null) {
            Object[] elements = itcp.getElements(viewer.getInput());
            int n = 0;
            while (n < elements.length) {
                if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)viewer, null, elements[n])) {
                    this.createStateAndStore(itcp, elements[n]);
                }
                ++n;
            }
        }
    }

    public Boolean isChecked(Object element) {
        ICheckedElement state = this.m_cachedStateMap.get(element);
        if (state != null) {
            return state.isChecked();
        }
        return null;
    }

    public Boolean isGreyed(Object element) {
        ICheckedElement state = this.m_cachedStateMap.get(element);
        if (state != null) {
            return state.isGreyed();
        }
        return null;
    }

    public boolean setChecked(Object element, boolean checked) {
        ITreeContentProvider itp = this.getTreeContentProvider();
        if (itp != null) {
            Object[] treeChildren = itp.getChildren(element);
            int n = 0;
            while (n < treeChildren.length) {
                if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)this.m_checkStateManager.getViewer(), element, treeChildren[n])) {
                    this.m_checkStateManager.setChecked(treeChildren[n], checked);
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    private ICheckedElement createStateAndStore(ITreeContentProvider itcp, Object element) {
        Object[] elements = itcp.getChildren(element);
        ICheckedElement state = elements.length == 0 ? this.createLeafState(element) : this.createContainerState(itcp, element, elements);
        this.m_cachedStateMap.put(element, state);
        return state;
    }

    private ICheckedElement createLeafState(Object element) {
        return new CachedCheckableElement(this.m_checkStateManager.getChecked(element), this.m_checkStateManager.getGreyed(element));
    }

    private ICheckedElement createContainerState(ITreeContentProvider itcp, Object parent, Object[] elements) {
        Object[] children = itcp.getChildren(parent);
        int checked = 0;
        int total = 0;
        int n = 0;
        while (n < children.length) {
            if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)this.m_checkStateManager.getViewer(), parent, children[n])) {
                ICheckedElement state = this.createStateAndStore(itcp, children[n]);
                if (state != null) {
                    if (Boolean.TRUE.equals(state.isGreyed())) {
                        return new CachedCheckableElement(Boolean.TRUE, Boolean.TRUE);
                    }
                    if (Boolean.TRUE.equals(state.isChecked())) {
                        ++checked;
                    }
                }
                ++total;
            }
            ++n;
        }
        return new CachedCheckableElement(new Boolean(checked > 0), new Boolean(checked > 0 && checked < total));
    }

    private ITreeContentProvider getTreeContentProvider() {
        IContentProvider provider = this.m_checkStateManager.getViewer().getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            return (ITreeContentProvider)provider;
        }
        return null;
    }

    private static final class CachedCheckableElement
    implements ICheckedElement {
        private final Boolean m_checked;
        private final Boolean m_grayed;

        public CachedCheckableElement(Boolean checked, Boolean grayed) {
            this.m_checked = checked;
            this.m_grayed = grayed;
        }

        public Boolean isChecked() {
            return this.m_checked;
        }

        public Boolean isGreyed() {
            return this.m_grayed;
        }

        public void setChecked(boolean checked) {
        }
    }
}

