/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.checkedstate;

import com.jrockit.mc.core.checkedstate.ICheckedStateModifier;
import com.jrockit.mc.core.checkedstate.ICheckedStateModifierProvider;
import com.jrockit.mc.core.checkedstate.ICheckedStateProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedStateManager {
    private final CheckboxTreeViewer m_checkboxViewer;
    private final CheckStateListener m_stateListener;
    private final TreeListener m_treeListener;
    private final List<ICheckedStateProvider> m_providers = new ArrayList<ICheckedStateProvider>();
    private final List<ICheckedStateModifier> m_modifiers = new ArrayList<ICheckedStateModifier>();

    public CheckedStateManager(CheckboxTreeViewer viewer) {
        this.m_checkboxViewer = viewer;
        this.m_stateListener = new CheckStateListener();
        this.m_treeListener = new TreeListener();
        this.m_checkboxViewer.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        this.m_checkboxViewer.addTreeListener((ITreeViewerListener)new TreeListener());
    }

    public void addCheckedStateProvider(ICheckedStateProvider provider) {
        this.m_providers.add(provider);
    }

    public void addCheckedStateModifier(ICheckedStateModifier modifier) {
        this.m_modifiers.add(modifier);
    }

    public void addModifierProvider(ICheckedStateModifierProvider modifierProvider) {
        this.addCheckedStateModifier(modifierProvider);
        this.addCheckedStateProvider(modifierProvider);
    }

    public void removeModifierProvider(ICheckedStateModifierProvider modifierProvider) {
        this.removeCheckedStateModifier(modifierProvider);
        this.removeCheckedStateProvider(modifierProvider);
    }

    public void fireCheckStateChange() {
        for (ICheckedStateProvider provider : this.m_providers) {
            provider.checkStateChanged(this.m_checkboxViewer);
        }
    }

    public void removeCheckedStateProvider(ICheckedStateProvider provider) {
        this.m_providers.remove(provider);
    }

    public void removeCheckedStateModifier(ICheckedStateModifier modifier) {
        this.m_modifiers.remove(modifier);
    }

    public void deselectAll() {
        this.setCheckedAll(false);
    }

    public void selectAll() {
        this.setCheckedAll(true);
    }

    private void setCheckedAll(boolean checked) {
        ArrayList<Object> checkList = new ArrayList<Object>();
        ITreeContentProvider treeProvider = (ITreeContentProvider)this.m_checkboxViewer.getContentProvider();
        if (treeProvider != null) {
            this.collectAll(checkList, treeProvider, null, treeProvider.getElements(this.m_checkboxViewer.getInput()));
        }
        Boolean shouldBe = new Boolean(checked);
        for (Object e : checkList) {
            if (shouldBe.equals(this.getChecked(e))) continue;
            this.setChecked(e, checked);
        }
        this.fireCheckStateChange();
        this.refresh();
    }

    public void setChecked(Object element, boolean checked) {
        for (ICheckedStateModifier modifier : this.m_modifiers) {
            modifier.setChecked(element, checked);
        }
    }

    public Boolean getChecked(Object element) {
        for (ICheckedStateProvider provider : this.m_providers) {
            Boolean result = provider.isChecked(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Boolean getGreyed(Object element) {
        for (ICheckedStateProvider provider : this.m_providers) {
            Boolean result = provider.isGreyed(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void refresh() {
        this.fireCheckStateChange();
        ArrayList<Object> checkList = new ArrayList<Object>();
        ArrayList<Object> grayList = new ArrayList<Object>();
        ITreeContentProvider treeProvider = (ITreeContentProvider)this.m_checkboxViewer.getContentProvider();
        if (treeProvider != null) {
            this.collectChildren(checkList, grayList, treeProvider, null, treeProvider.getElements(this.m_checkboxViewer.getInput()));
        }
        this.m_checkboxViewer.setCheckedElements(new Object[0]);
        this.m_checkboxViewer.setCheckedElements(checkList.toArray());
        this.m_checkboxViewer.setGrayedElements(grayList.toArray());
        this.m_checkboxViewer.update(grayList.toArray(), new String[0]);
    }

    private void collectAll(List<Object> items, ITreeContentProvider treeProvider, Object parent, Object[] elements) {
        int n = 0;
        while (n < elements.length) {
            if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)this.m_checkboxViewer, parent, elements[n])) {
                items.add(elements[n]);
                this.collectAll(items, treeProvider, elements[n], treeProvider.getChildren(elements[n]));
            }
            ++n;
        }
    }

    public Collection getAllChecked() {
        ArrayList<Object> checkList = new ArrayList<Object>();
        ArrayList<Object> grayList = new ArrayList<Object>();
        ITreeContentProvider treeProvider = (ITreeContentProvider)this.m_checkboxViewer.getContentProvider();
        if (treeProvider != null) {
            this.collectChildren(checkList, grayList, treeProvider, null, treeProvider.getElements(this.m_checkboxViewer.getInput()));
        }
        return checkList;
    }

    private void collectChildren(List<Object> checkList, List<Object> grayList, ITreeContentProvider treeProvider, Object parent, Object[] elements) {
        int n = 0;
        while (n < elements.length) {
            if (CheckedStateManager.isElementAcceptedByViewer((StructuredViewer)this.m_checkboxViewer, parent, elements[n])) {
                Boolean isGrayed;
                Boolean isChecked = this.getChecked(elements[n]);
                if (isChecked != null && isChecked.booleanValue()) {
                    checkList.add(elements[n]);
                }
                if ((isGrayed = this.getGreyed(elements[n])) != null && isGrayed.booleanValue()) {
                    grayList.add(elements[n]);
                }
                this.collectChildren(checkList, grayList, treeProvider, elements[n], treeProvider.getChildren(elements[n]));
            }
            ++n;
        }
    }

    public CheckboxTreeViewer getViewer() {
        return this.m_checkboxViewer;
    }

    public static boolean isElementAcceptedByViewer(StructuredViewer viewer, Object parent, Object element) {
        ViewerFilter[] filters = viewer.getFilters();
        int acceptedCount = 0;
        int n = 0;
        while (n < filters.length) {
            if (filters[n].select((Viewer)viewer, parent, element)) {
                ++acceptedCount;
            }
            ++n;
        }
        return acceptedCount == filters.length;
    }

    public void dispose() {
        this.m_modifiers.clear();
        this.m_providers.clear();
        this.m_checkboxViewer.removeCheckStateListener((ICheckStateListener)this.m_stateListener);
        this.m_checkboxViewer.removeTreeListener((ITreeViewerListener)this.m_treeListener);
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            CheckedStateManager.this.setChecked(event.getElement(), event.getChecked());
            CheckedStateManager.this.fireCheckStateChange();
            CheckedStateManager.this.refresh();
        }
    }

    private class TreeListener
    implements ITreeViewerListener {
        private TreeListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            event.getTreeViewer().getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CheckedStateManager.this.refresh();
                }
            });
        }
    }
}

