/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;

public class TableColumnSortManager {
    private final TableViewer m_tableViewer;

    public TableColumnSortManager(TableViewer tableViewer) {
        this.m_tableViewer = tableViewer;
    }

    public void addColumn(TableColumn tableColumn, int labelProviderIndex, boolean firstSorderAscending) {
        if (tableColumn != null && !tableColumn.isDisposed() && !tableColumn.isListening(13)) {
            tableColumn.addListener(13, (Listener)new SortChangeListener(labelProviderIndex, firstSorderAscending));
        }
    }

    class SortChangeListener
    implements Listener {
        private final int m_labelProviderIndex;
        private final boolean m_firstSortOrderAscending;
        private TableColumnSorter m_lastSorter;

        public SortChangeListener(int labelProviderIndex, boolean firstSorderAscending) {
            this.m_labelProviderIndex = labelProviderIndex;
            this.m_firstSortOrderAscending = firstSorderAscending;
        }

        public void handleEvent(Event event) {
            if (TableColumnSortManager.this.m_tableViewer != null) {
                boolean sortOrder = this.m_firstSortOrderAscending;
                if (this.m_lastSorter == TableColumnSortManager.this.m_tableViewer.getSorter() && this.m_lastSorter != null) {
                    sortOrder = !this.m_lastSorter.isSortingAscending();
                }
                this.m_lastSorter = new TableColumnSorter(this.m_labelProviderIndex, sortOrder);
                TableColumnSortManager.this.m_tableViewer.setSorter((ViewerSorter)this.m_lastSorter);
            } else {
                System.err.println("Sort manager is missing viewer.");
            }
        }
    }

    class TableColumnSorter
    extends ViewerSorter {
        private final boolean m_sortOrderAscending;
        private final int m_columnIndex;

        public TableColumnSorter(int columnIndex, boolean sortOrderAscending) {
            this.m_columnIndex = columnIndex;
            this.m_sortOrderAscending = sortOrderAscending;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            TableViewer tableViewer;
            IBaseLabelProvider ibp;
            if (viewer instanceof TableViewer && (ibp = (tableViewer = (TableViewer)viewer).getLabelProvider()) instanceof ITableLabelProvider) {
                ITableLabelProvider itlp = (ITableLabelProvider)ibp;
                String stringElement1 = itlp.getColumnText(e1, this.m_columnIndex);
                String stringElement2 = itlp.getColumnText(e2, this.m_columnIndex);
                Integer value1 = this.getInteger(stringElement1);
                Integer value2 = this.getInteger(stringElement2);
                if (value1 != null && value2 != null) {
                    return (this.m_sortOrderAscending ? 1 : -1) * (value1 - value2);
                }
                if (stringElement1 != null && stringElement2 != null) {
                    return this.compareWithSortOrder(viewer, e1, e2);
                }
            }
            return super.compare(viewer, e1, e2);
        }

        boolean isSortingAscending() {
            return this.m_sortOrderAscending;
        }

        private int compareWithSortOrder(Viewer viewer, Object e1, Object e2) {
            if (this.m_sortOrderAscending) {
                return super.compare(viewer, e1, e2);
            }
            return super.compare(viewer, e2, e1);
        }

        private Integer getInteger(String stringValue) {
            Integer integerValue;
            try {
                integerValue = new Integer(stringValue);
            }
            catch (Exception e) {
                integerValue = null;
            }
            return integerValue;
        }

        public int getLabelProviderIndex() {
            return this.m_columnIndex;
        }
    }
}

