/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import java.util.ArrayList;
import java.util.List;

public class PollManager {
    private long m_pollingInterval;
    private List<IPollable> m_pollableObjects = new ArrayList<IPollable>();
    private volatile boolean m_keepAlive;

    public PollManager() {
        this.fetchUpdateInterval();
    }

    private Object getLockTocken() {
        return this.m_pollableObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchUpdateInterval() {
        long pollingInterval = 2500L;
        Object object = this.getLockTocken();
        synchronized (object) {
            this.m_pollingInterval = pollingInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPollable(IPollable pollable) {
        Object object = this.getLockTocken();
        synchronized (object) {
            if (!this.m_pollableObjects.contains(pollable)) {
                this.m_pollableObjects.add(pollable);
                this.updatePollThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePollable(IPollable pollable) {
        List<IPollable> list = this.m_pollableObjects;
        synchronized (list) {
            if (this.m_pollableObjects.remove(pollable)) {
                this.updatePollThread();
            }
        }
    }

    private void updatePollThread() {
        if (this.m_pollableObjects.isEmpty()) {
            this.stopIfNotStopped();
        } else {
            this.startIfNotStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIfNotStarted() {
        Object object = this.getLockTocken();
        synchronized (object) {
            if (!this.m_keepAlive) {
                this.m_keepAlive = true;
                new Thread(this.createPoolRunner(), "Polling Thread").start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIfNotStopped() {
        Object object = this.getLockTocken();
        synchronized (object) {
            if (this.m_keepAlive) {
                this.m_keepAlive = false;
                this.getLockTocken().notifyAll();
            }
        }
    }

    private Runnable createPoolRunner() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (PollManager.this.m_keepAlive) {
                    try {
                        if (PollManager.this.m_keepAlive) {
                            PollManager.this.pollAllPollables();
                        }
                        Object object = PollManager.this.getLockTocken();
                        synchronized (object) {
                            PollManager.this.getLockTocken().wait(PollManager.this.m_pollingInterval);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollAllPollables() {
        Object object = this.getLockTocken();
        synchronized (object) {
            IPollable[] pollables;
            IPollable[] iPollableArray = pollables = this.m_pollableObjects.toArray(new IPollable[this.m_pollableObjects.size()]);
            int n = pollables.length;
            int n2 = 0;
            while (n2 < n) {
                IPollable pollable = iPollableArray[n2];
                if (!pollable.poll()) {
                    this.m_pollableObjects.remove(pollable);
                }
                ++n2;
            }
        }
    }

    public static interface IPollable {
        public boolean poll();
    }
}

