/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MCVersion {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.core");
    private static final String PROPERTY_FULL_VERSION = "jrmc.fullversion";
    private static final String DEFAULT_FULL_VERSION = "debug";
    private static final String FULL_VERSION = MCVersion.initVersion();
    private static final String PROPERTY_BUILD_NUMBER = "jrmc.buildnumber";
    private static final String DEFAULT_BUILD_NUMBER = "0";
    private static final String BUILD_NUMBER = MCVersion.initBuildNo();
    private static final String PROPERTY_CHANGE_NUMBER = "jrmc.changenumber";
    private static final String DEFAULT_CHANGE_NUMBER = "0";
    private static final String CHANGE_NUMBER = MCVersion.initChangeNo();

    private static String initVersion() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getFullVersion(versionProperties) == null || MCVersion.getFullVersion(versionProperties).startsWith("@")) {
            return DEFAULT_FULL_VERSION;
        }
        return MCVersion.getFullVersion(versionProperties);
    }

    private static String getFullVersion(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_FULL_VERSION);
        }
        return null;
    }

    private static String initBuildNo() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getBuildNo(versionProperties) == null || MCVersion.getBuildNo(versionProperties).startsWith("@")) {
            return "0";
        }
        return MCVersion.getBuildNo(versionProperties);
    }

    private static String getBuildNo(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_BUILD_NUMBER);
        }
        return null;
    }

    private static String initChangeNo() {
        Properties versionProperties = MCVersion.getVersionProperties();
        if (MCVersion.getChangeNo(versionProperties) == null || MCVersion.getChangeNo(versionProperties).startsWith("@")) {
            return "0";
        }
        return MCVersion.getChangeNo(versionProperties);
    }

    private static String getChangeNo(Properties versionProperties) {
        if (versionProperties != null) {
            return versionProperties.getProperty(PROPERTY_CHANGE_NUMBER);
        }
        return null;
    }

    private static Properties getVersionProperties() {
        Properties versionProperties = new Properties();
        InputStream is = MCVersion.class.getResourceAsStream("/version.properties");
        if (is == null) {
            LOGGER.log(Level.SEVERE, "Could not open version.properties file.");
            return null;
        }
        try {
            versionProperties.load(is);
            is.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error loading version.properties file.", e);
            return null;
        }
        return versionProperties;
    }

    public static String getFullVersion() {
        return FULL_VERSION;
    }

    public static String getChangeNumber() {
        return CHANGE_NUMBER;
    }

    public static String getBuildNumber() {
        return BUILD_NUMBER;
    }
}

