/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.HorizontalAction;
import com.jrockit.mc.core.OrientationAction;
import com.jrockit.mc.core.VerticalAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class MCMasterDetailsBlock
extends MasterDetailsBlock {
    private String m_preferenceId;
    private IManagedForm m_managedForm;
    protected int[] m_weights = null;
    protected boolean m_horizontal = false;

    public MCMasterDetailsBlock() {
    }

    public MCMasterDetailsBlock(String id, boolean defaultHorizontal) {
        this.m_preferenceId = id;
        if (this.m_preferenceId != null) {
            CorePlugin.getDefault().getPreferenceStore().setDefault(this.m_preferenceId, defaultHorizontal);
        }
        this.m_horizontal = this.getHoriontal();
    }

    private boolean getHoriontal() {
        if (this.m_preferenceId != null) {
            return CorePlugin.getDefault().getPreferenceStore().getBoolean(this.m_preferenceId);
        }
        return false;
    }

    private void storeHorizontal(boolean horizontal) {
        if (this.m_preferenceId != null) {
            CorePlugin.getDefault().getPreferenceStore().setValue(this.m_preferenceId, horizontal);
        }
    }

    private void hookResizeListener() {
        Listener listener = ((MDSashForm)this.sashForm).listener;
        Control[] children = this.sashForm.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash)) {
                children[i].addListener(11, listener);
            }
            ++i;
        }
    }

    public void setWeights(int[] weights) {
        this.m_weights = weights;
    }

    public final void setOrientation(boolean horizontal) {
        this.m_horizontal = horizontal;
    }

    protected abstract void createMasterPart(IManagedForm var1, Composite var2);

    public void createContent(IManagedForm managedForm, Composite parent) {
        this.m_managedForm = managedForm;
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        int style = !this.m_horizontal ? 256 : 512;
        this.sashForm = new MDSashForm(parent, style);
        toolkit.adapt((Control)this.sashForm, false, false);
        this.sashForm.setMenu(parent.getMenu());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.createMasterPart(managedForm, (Composite)this.sashForm);
        this.createDetailsPart(managedForm, (Composite)this.sashForm);
        this.hookResizeListener();
        this.createToolBarActions(managedForm);
        form.updateToolBar();
        if (this.m_weights != null) {
            this.sashForm.setWeights(this.m_weights);
        }
    }

    private void createDetailsPart(IManagedForm mform, Composite parent) {
        this.detailsPart = new DetailsPart(mform, parent, 0);
        mform.addPart((IFormPart)this.detailsPart);
        this.registerPages(this.detailsPart);
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        HorizontalAction h = new HorizontalAction(managedForm, this.sashForm, !this.m_horizontal);
        VerticalAction v = new VerticalAction(managedForm, this.sashForm, this.m_horizontal);
        if (this.m_preferenceId != null) {
            this.hookOrientationListener(h);
            this.hookOrientationListener(v);
        }
        managedForm.getForm().getToolBarManager().add((IAction)h);
        managedForm.getForm().getToolBarManager().add((IAction)v);
    }

    private void hookOrientationListener(OrientationAction action) {
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("PROPERTY_ORIENTATION_CHANGE".equals(event.getProperty())) {
                    Integer newOrientation = (Integer)event.getNewValue();
                    MCMasterDetailsBlock.this.storeHorizontal(newOrientation != 256);
                }
            }
        });
    }

    public void flush() {
        int limit = this.detailsPart.getPageLimit();
        this.detailsPart.setPageLimit(0);
        this.detailsPart.selectionChanged(null, (ISelection)new StructuredSelection());
        this.detailsPart.selectionChanged(null, (ISelection)new StructuredSelection());
        this.detailsPart.setPageLimit(limit);
    }

    private void onSashPaint(Event e) {
        this.sashForm.layout(true, true);
        Sash sash = (Sash)e.widget;
        FormColors colors = this.m_managedForm.getToolkit().getColors();
        boolean vertical = (sash.getStyle() & 0x200) != 0;
        GC gc = e.gc;
        Boolean hover = (Boolean)sash.getData("hover");
        gc.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
        gc.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        Point size = sash.getSize();
        if (vertical) {
            if (hover != null) {
                gc.fillRectangle(0, 0, size.x, size.y);
            }
        } else if (hover != null) {
            gc.fillRectangle(0, 0, size.x, size.y);
        }
    }

    class MDSashForm
    extends SashForm {
        ArrayList sashes;
        Listener listener;

        public MDSashForm(Composite parent, int style) {
            super(parent, style);
            this.sashes = new ArrayList();
            this.listener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 6: {
                            e.widget.setData("hover", (Object)Boolean.TRUE);
                            ((Control)e.widget).redraw();
                            break;
                        }
                        case 7: {
                            e.widget.setData("hover", null);
                            ((Control)e.widget).redraw();
                            break;
                        }
                        case 9: {
                            MCMasterDetailsBlock.this.onSashPaint(e);
                            break;
                        }
                        case 11: {
                            MDSashForm.this.hookSashListeners();
                        }
                    }
                }
            };
        }

        public void layout(boolean changed) {
            super.layout(changed);
            this.hookSashListeners();
        }

        public void layout(Control[] children) {
            super.layout(children);
            this.hookSashListeners();
        }

        private void hookSashListeners() {
            this.purgeSashes();
            Control[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                Sash sash;
                if (children[i] instanceof Sash && !this.sashes.contains(sash = (Sash)children[i])) {
                    sash.addListener(9, this.listener);
                    sash.addListener(6, this.listener);
                    sash.addListener(7, this.listener);
                    this.sashes.add(sash);
                }
                ++i;
            }
        }

        private void purgeSashes() {
            Iterator iter = this.sashes.iterator();
            while (iter.hasNext()) {
                Sash sash = (Sash)iter.next();
                if (!sash.isDisposed()) continue;
                iter.remove();
            }
        }
    }
}

