/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdapterUtil {
    private AdapterUtil() {
    }

    public static <T> T getAdapter(Object adaptable, Class<T> adapterClass) {
        Object adapter;
        if (adaptable instanceof IAdaptable && adapterClass.isInstance(adapter = ((IAdaptable)adaptable).getAdapter(adapterClass))) {
            return (T)adapter;
        }
        if (adaptable == null) {
            return null;
        }
        adapter = Platform.getAdapterManager().getAdapter(adaptable, adapterClass);
        if (adapterClass.isInstance(adapter)) {
            return (T)adapter;
        }
        return null;
    }

    public static boolean hasAdapter(Object adaptable, Class<?> adapterClass) {
        Object adapter;
        boolean hasAdapter = Platform.getAdapterManager().hasAdapter(adaptable, adapterClass.getName());
        if (hasAdapter) {
            return true;
        }
        return adaptable instanceof IAdaptable && adapterClass.isInstance(adapter = ((IAdaptable)adaptable).getAdapter(adapterClass));
    }

    public static <T> List<T> adaptAllTo(IStructuredSelection selection, Class<T> adapterClass) {
        if (selection == null) {
            return Collections.emptyList();
        }
        Iterator elems = selection.iterator();
        ArrayList<T> adapters = new ArrayList<T>(selection.size());
        while (elems.hasNext()) {
            Object elem = elems.next();
            T adapter = AdapterUtil.getAdapter(elem, adapterClass);
            if (adapter == null) continue;
            adapters.add(adapter);
        }
        return adapters;
    }
}

