/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCActivity;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.IWorkbenchConfigurer;

public final class ActivitiesToolkit {
    private static final Set<MCActivity> ACTIVITIES = new HashSet<MCActivity>();
    private static final Object APPLICATION_ARGS_KEY = "application.args";

    public static boolean hasActivityEnabled(MCActivity activity) {
        IWorkbenchActivitySupport activitySupport = CorePlugin.getDefault().getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        return activityManager.getActivity(activity.id).isDefined();
    }

    public static void enableActivities(IWorkbenchConfigurer configurer) {
        IWorkbenchActivitySupport activitySupport = configurer.getWorkbench().getActivitySupport();
        IActivityManager activityManager = activitySupport.getActivityManager();
        HashSet<String> activityIds = new HashSet<String>();
        for (MCActivity activity : ACTIVITIES) {
            if (!activityManager.getActivity(activity.id).isDefined()) continue;
            activityIds.add(activity.id);
        }
        activitySupport.setEnabledActivityIds(activityIds);
    }

    public static void collectActivitiesArguments(IApplicationContext context) {
        String[] applicationArgs = (String[])context.getArguments().get(APPLICATION_ARGS_KEY);
        int n = 0;
        while (n < applicationArgs.length) {
            MCActivity[] mCActivityArray = MCActivity.values();
            int n2 = mCActivityArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MCActivity activity = mCActivityArray[n3];
                if (activity.commandLineArgument.equals(applicationArgs[n])) {
                    ACTIVITIES.add(activity);
                }
                ++n3;
            }
            ++n;
        }
    }
}

