/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRecordingRepository;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class SaveWizardDialog
extends WizardPage
implements IPerformFinishable {
    private final RecordingTemplate m_template;
    private final TemplateRecordingRepository m_repository;

    protected SaveWizardDialog(TemplateRecordingRepository repository) {
        super("saveRecordingTemplate");
        this.m_repository = repository;
        this.m_template = (RecordingTemplate)PersistenceToolkit.createWorkingCopy((Object)repository.getActive());
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.SAVE_TEMPLATE_WIZARD_PAGE_TITLE);
        this.setDescription(Messages.SAVE_TEMPLATE_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gd1 = new GridData(4, 4, false, false);
        Label nameLabel = this.createNameLabel(container);
        nameLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Text nameText = this.createNameText(container);
        nameText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        Label descriptionLabel = this.createDescriptionLabel(container);
        descriptionLabel.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, true);
        Text descriptiontext = this.createDescriptionText(container);
        descriptiontext.setLayoutData((Object)gd4);
        this.setControl((Control)container);
    }

    private Text createDescriptionText(Composite parent) {
        final Text text = new Text(parent, 2114);
        text.setText(this.m_template.getDescription());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveWizardDialog.this.m_template.setDescription(text.getText());
            }
        });
        return text;
    }

    private Label createDescriptionLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_DESCRIPTION_TEXT);
        return label;
    }

    private Text createNameText(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText(this.m_template.getName());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveWizardDialog.this.m_template.setName(text.getText());
                if (SaveWizardDialog.this.m_repository.isAllowedName(SaveWizardDialog.this.m_template.getName())) {
                    SaveWizardDialog.this.setErrorMessage(null);
                    SaveWizardDialog.this.setPageComplete(true);
                } else {
                    SaveWizardDialog.this.setErrorMessage(Messages.SAVE_TEMPLATE_WIZARD_PAGE_DUPLICATE_ERROR_MSG);
                    SaveWizardDialog.this.setPageComplete(false);
                }
            }
        });
        return text;
    }

    private Label createNameLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_NAME_TEXT);
        return label;
    }

    public boolean performFinish() {
        PersistenceToolkit.commit((Object)this.m_template);
        return true;
    }
}

