/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRecordingRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.AdvancedWizardPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.SaveWizardDialog;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateProvider;
import com.jrockit.mc.rjmx.core.internal.TimeRangeToolkit;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.flr.OptionMetadata;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class RecordingWizardPage
extends WizardPage
implements IPerformFinishable {
    private static final int MAX_DIALOG_HEIGHT = 600;
    private static final int MIN_DIALOG_HEIGHT = 400;
    private static final int MAX_DIALOG_WIDTH = 800;
    private static final int MIN_DIALOG_WIDTH = 600;
    private static final int VISIBLE_ITEMS_IN_COMBO = 10;
    private static final int DEFAULT_DURATION = 60000;
    public static final long NO_MAX_SIZE = -1L;
    public static final long NO_MAX_AGE = -1L;
    private ComboViewer m_comboViewer;
    private Control m_removeButton;
    private Control m_saveButton;
    private Text m_description;
    private Text m_filenameText;
    private Button m_fixedOption;
    private Text m_durationText;
    private Button m_continuousOption;
    private Text m_maxSizeText;
    private Text m_maxAgeText;
    private final boolean m_editing;
    private TemplateRecordingRepository m_templateRepository;
    private IPath m_path;
    private String m_name;
    private boolean m_fixedRecording;
    private long m_duration;
    private long m_maxSize;
    private long m_maxAge;
    private final IFlightRecorderService m_flightRecorderService;

    public RecordingWizardPage(IFlightRecorderService flightRecorderService) {
        super("startRecordingWizard");
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjrawiz.gif"));
        this.m_flightRecorderService = flightRecorderService;
        this.m_templateRepository = ControlPanel.getDefault().getTemplateRecordingRepository();
        this.m_path = RecordingWizardPage.getDefaultRecordingFileName();
        this.m_name = Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME;
        this.m_duration = 60000L;
        this.m_maxSize = -1L;
        this.m_maxAge = -1L;
        this.m_editing = false;
    }

    public RecordingWizardPage(JvmModel jvmModel, IRecordingDescriptor recordingDescriptor) {
        super("editRecordingWizard");
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjrawiz.gif"));
        this.m_flightRecorderService = jvmModel.getFlightRecorderService();
        this.m_templateRepository = ControlPanel.getDefault().getTemplateRecordingRepository();
        TemplateRepositoryToolkit.findTemplate(this.m_templateRepository, jvmModel, recordingDescriptor);
        String filename = jvmModel.getClientSideProperty(recordingDescriptor, "jvmmodel.clientSideFilename");
        this.m_path = filename != null ? new Path(filename) : RecordingWizardPage.getDefaultRecordingFileName();
        this.m_name = recordingDescriptor.getName();
        this.m_duration = recordingDescriptor.getDuration();
        this.m_maxSize = recordingDescriptor.getMaxSize();
        if (this.m_maxSize == 0L) {
            this.m_maxSize = -1L;
        }
        this.m_maxAge = recordingDescriptor.getMaxAge();
        if (this.m_maxAge == 0L) {
            this.m_maxAge = -1L;
        }
        this.m_editing = true;
    }

    public IPath getPath() {
        return this.m_path;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isFixedRecording() {
        return this.m_fixedRecording;
    }

    public long getDuration() {
        return this.m_duration;
    }

    public long getMaxSize() {
        return this.m_maxSize;
    }

    public long getMaxAge() {
        return this.m_maxAge;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int indent = this.convertWidthInCharsToPixels(4);
        if (this.m_editing) {
            this.setTitle(Messages.EDIT_RECORDING_WIZARD_PAGE_TITLE);
            this.setDescription(Messages.EDIT_RECORDING_WIZARD_PAGE_DESCRIPTION);
        } else {
            this.setTitle(Messages.START_RECORDING_WIZARD_PAGE_TITLE);
            this.setDescription(Messages.START_RECORDING_WIZARD_PAGE_DESCRIPTION);
        }
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Composite settingsContainer = this.createSettingsContainer(container, indent);
        settingsContainer.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Label separator = this.creatSeparator(container);
        separator.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        Composite descriptionContainer = this.createTemplateDescriptionContainer(container);
        descriptionContainer.setLayoutData((Object)gd3);
        this.refresh();
        this.selectInitialOption();
        this.setControl((Control)container);
    }

    private void selectInitialOption() {
        this.m_fixedRecording = this.m_duration > 0L;
        this.m_fixedOption.setSelection(this.m_fixedRecording);
        this.setFixedRecordingControlsEnabled(this.m_fixedRecording);
        this.m_continuousOption.setSelection(!this.m_fixedRecording);
        this.setContinuousRecordingControlsEnabled(!this.m_fixedRecording);
    }

    public boolean performFinish() {
        if (this.validateSettings()) {
            this.storeSettings();
            return true;
        }
        return false;
    }

    private void storeSettings() {
        try {
            this.m_duration = TimeRangeToolkit.parseMillis((String)this.m_durationText.getText());
            String text = this.m_maxSizeText.getText();
            this.m_maxSize = text.length() == 0 ? -1L : Long.valueOf(text);
        }
        catch (Exception e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not parse value even though validation passed! This should not happen! ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSettings() {
        try {
            if (this.m_name.length() == 0) {
                this.setMessage(Messages.RECORDING_WIZARD_PAGE_RECORDING_NAME_ERROR_MSG, 3);
                return false;
            }
            TimeRangeToolkit.parseMillis((String)this.m_durationText.getText());
            String text = this.m_maxSizeText.getText();
            if (text.length() != 0) {
                try {
                    long maxSize = Long.valueOf(text);
                    if (maxSize < 0L) {
                        this.setMessage(Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, 3);
                        return false;
                    }
                }
                catch (NumberFormatException e1) {
                    this.setMessage(Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, 3);
                    return false;
                }
            }
            if ((text = this.m_maxAgeText.getText()).length() > 0) {
                TimeRangeToolkit.parseMillis((String)text);
            }
            if (this.m_path == null) {
                this.setMessage(Messages.RECORDING_WIZARD_PAGE_NOT_VALID_FOLDER);
                return false;
            }
            this.setMessage(null);
            return true;
        }
        catch (Exception e) {
            this.setMessage(e.getMessage(), 3);
            return false;
        }
    }

    private void createTemplateControls(Composite parent) {
        GridData gd0 = new GridData(4, 4, true, false);
        Label bar = new Label(parent, 1);
        bar.setText(Messages.LABEL_TEMPLATE);
        bar.setLayoutData((Object)gd0);
        GridData gd1 = new GridData(4, 4, true, false);
        this.m_comboViewer = this.createSelector(parent);
        this.m_comboViewer.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        Button advancedButton = this.createAdvancedButton(parent);
        advancedButton.setLayoutData((Object)gd2);
        GridData gd4 = new GridData(4, 4, false, false);
        this.m_saveButton = this.createSaveButton(parent);
        this.m_saveButton.setLayoutData((Object)gd4);
        GridData gd5 = new GridData(4, 4, false, false);
        this.m_removeButton = this.createRemoveButton(parent);
        this.m_removeButton.setLayoutData((Object)gd5);
        this.hookSelectionListener();
    }

    private void hookSelectionListener() {
        this.m_comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RecordingTemplate t = RecordingWizardPage.this.getSelected();
                if (t != null) {
                    RecordingWizardPage.this.setActiveTemplate(t);
                }
            }
        });
    }

    private Button createAdvancedButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_ADVANCED_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.openAdvanced();
            }
        });
        return button;
    }

    private Button createRemoveButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_REMOVE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.m_templateRepository.remove(RecordingWizardPage.this.getTemplate());
                RecordingWizardPage.this.refresh();
            }
        });
        return button;
    }

    private void refresh() {
        this.m_comboViewer.refresh();
        this.updateSelection();
        this.updateButtons();
    }

    private void updateSelection() {
        this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_templateRepository.getActive()));
    }

    private void updateButtons() {
        this.m_removeButton.setEnabled(this.getTemplate().isModifiable());
        this.m_saveButton.setEnabled(this.m_templateRepository.isUnsaved(this.getTemplate()));
    }

    public RecordingTemplate getTemplate() {
        return this.m_templateRepository.getActive();
    }

    private RecordingTemplate getSelected() {
        IStructuredSelection ss = (IStructuredSelection)this.m_comboViewer.getSelection();
        return (RecordingTemplate)(!ss.isEmpty() ? ss.getFirstElement() : null);
    }

    private Button createSaveButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_SAVE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.showSaveRecordingTemplate();
            }
        });
        return button;
    }

    private Composite createTemplateDescriptionContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Control label = this.createTemplateDescriptionLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 160;
        Control description = this.createDescriptionText(parent);
        description.setLayoutData((Object)gd2);
        return container;
    }

    private Control createTemplateDescriptionLabel(Composite parent) {
        Label descriptionLabel = new Label(parent, 1);
        descriptionLabel.setText(Messages.LABEL_TEMPLATE_DESCRIPTION);
        descriptionLabel.setFont(CorePlugin.getDefault().getFontColorToolkit().getStandardBoldFont());
        return descriptionLabel;
    }

    private Control createDescriptionText(Composite parent) {
        this.m_description = new Text(parent, 586);
        return this.m_description;
    }

    private Label creatSeparator(Composite parent) {
        return new Label(parent, 258);
    }

    private ComboViewer createSelector(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent);
        comboViewer.getCombo().setVisibleItemCount(10);
        comboViewer.setContentProvider((IContentProvider)new TemplateProvider());
        comboViewer.setInput((Object)this.m_templateRepository);
        comboViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider(this.m_templateRepository));
        return comboViewer;
    }

    public void setActiveTemplate(RecordingTemplate rt) {
        this.m_templateRepository.setActive(rt);
        this.setDescriptionText(rt);
        this.updateButtons();
    }

    private void setDescriptionText(RecordingTemplate rt) {
        if (this.m_description != null && !this.m_description.isDisposed()) {
            String description = rt != null ? rt.getDescription() : "";
            this.m_description.setText(description);
            this.m_description.setToolTipText(description);
        }
    }

    private Composite createSettingsContainer(Composite parent, int indent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        container.setLayout((Layout)layout);
        this.createTemplateControls(container);
        this.createFileNameInput(container);
        this.createName(container);
        this.createTimeFixedOption(container);
        this.createDuration(container, indent);
        this.createContinuousOption(container);
        this.createMaxSize(container, indent);
        this.createMaxAge(container, indent);
        return container;
    }

    private void createFileNameInput(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, true);
        Label label = this.createFilenameLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 3;
        this.m_filenameText = this.createFilenameText(parent);
        this.m_filenameText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, true);
        Button browseButton = this.createFilenameBrowseButton(parent);
        browseButton.setLayoutData((Object)gd3);
        this.updateFilename();
    }

    private Text createFilenameText(Composite parent) {
        return new Text(parent, 2056);
    }

    private void updateFilename() {
        this.m_filenameText.setText(this.m_path == null ? "" : this.m_path.toOSString());
        this.validateSettings();
    }

    private Label createFilenameLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILENAME_TEXT);
        return label;
    }

    private Button createFilenameBrowseButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath path = RecordingWizardPage.openRecordingFileBrowser(RecordingWizardPage.this.m_path);
                if (path != null) {
                    RecordingWizardPage.this.m_path = path;
                    RecordingWizardPage.this.updateFilename();
                }
                button.setFocus();
            }
        });
        return button;
    }

    public static IPath getDefaultRecordingFileName() {
        return CorePlugin.getDefault().getIDESupport().getValidDefaultFile(Messages.RECORDING_DEFAULT_FILENAME, "jfr");
    }

    public static IPath openRecordingFileBrowser(IPath currentPath) {
        return CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow(), Messages.RECORDING_FILE_BROWSER_TITLE, Messages.RECORDING_DEFAULT_FILENAME, currentPath, "jfr", CorePlugin.getDefault().getImageDescriptor("layout.gif"), Messages.RECORDING_FILE_BROWSER_DESCRIPTION);
    }

    private void createName(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, true);
        Label label = this.createNameLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createNameText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Text createNameText(Composite parent) {
        final Text text = new Text(parent, 2048);
        this.findToolTipText((Control)text, "recordingOption.name");
        text.setText(this.m_name);
        text.setEditable(!this.m_editing);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.m_name = text.getText();
                RecordingWizardPage.this.validateSettings();
            }
        });
        return text;
    }

    private Label createNameLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_NAME_TEXT);
        return label;
    }

    private void createTimeFixedOption(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = 5;
        this.m_fixedOption = new Button(parent, 16);
        this.m_fixedOption.setText(Messages.BUTTON_TIME_FIXED_RECORDING_TEXT);
        this.m_fixedOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.m_fixedRecording = true;
                RecordingWizardPage.this.setFixedRecordingControlsEnabled(true);
                RecordingWizardPage.this.setContinuousRecordingControlsEnabled(false);
            }
        });
        this.m_fixedOption.setLayoutData((Object)gd1);
    }

    private void createDuration(Composite parent, int indent) {
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalIndent = indent;
        Label label = this.createDurationLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createDurationText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Text createDurationText(Composite parent) {
        this.m_durationText = new Text(parent, 2048);
        this.findToolTipText((Control)this.m_durationText, "recordingOption.duration");
        this.m_durationText.setText(TimeRangeToolkit.convertMillisToNormalizedString((long)this.m_duration));
        this.m_durationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.validateSettings();
            }
        });
        return this.m_durationText;
    }

    private Label createDurationLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_RECORDING_TIME_TEXT);
        return label;
    }

    private void setFixedRecordingControlsEnabled(boolean enabled) {
        this.m_durationText.setEnabled(enabled);
    }

    private void createContinuousOption(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = 5;
        this.m_continuousOption = new Button(parent, 16);
        this.m_continuousOption.setText(Messages.BUTTON_CONTINUOUS_RECORDING_TEXT);
        this.m_continuousOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.m_fixedRecording = false;
                RecordingWizardPage.this.setFixedRecordingControlsEnabled(false);
                RecordingWizardPage.this.setContinuousRecordingControlsEnabled(true);
            }
        });
        this.m_continuousOption.setLayoutData((Object)gd1);
    }

    private void createMaxSize(Composite parent, int indent) {
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalIndent = indent;
        Label label = this.createMaxSizeLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createMaxSizeText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Label createMaxSizeLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_MAX_SIZE);
        return label;
    }

    private Text createMaxSizeText(Composite parent) {
        this.m_maxSizeText = new Text(parent, 2048);
        if (this.m_editing && this.m_maxSize > -1L) {
            this.m_maxSizeText.setText(Long.toString(this.m_maxSize));
        }
        this.findToolTipText((Control)this.m_maxSizeText, "recordingOption.maxSize");
        this.m_maxSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.validateSettings();
            }
        });
        return this.m_maxSizeText;
    }

    private void createMaxAge(Composite parent, int indent) {
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalIndent = indent;
        Label label = this.createMaxAgeLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createMaxAgeText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Label createMaxAgeLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_MAX_AGE);
        return label;
    }

    private Text createMaxAgeText(Composite parent) {
        this.m_maxAgeText = new Text(parent, 2048);
        if (this.m_editing && this.m_maxAge > -1L) {
            this.m_maxAgeText.setText(TimeRangeToolkit.convertMillisToNormalizedString((long)this.m_maxAge));
        }
        this.findToolTipText((Control)this.m_maxAgeText, "recordingOption.maxAge");
        this.m_maxAgeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = RecordingWizardPage.this.m_maxAgeText.getText();
                if (text.length() == 0) {
                    RecordingWizardPage.this.m_maxAge = -1L;
                } else {
                    try {
                        RecordingWizardPage.this.m_maxAge = TimeRangeToolkit.parseMillis((String)text);
                        RecordingWizardPage.this.setMessage(null);
                    }
                    catch (Exception e1) {
                        RecordingWizardPage.this.setMessage(e1.getMessage(), 3);
                    }
                }
            }
        });
        return this.m_maxAgeText;
    }

    private void setContinuousRecordingControlsEnabled(boolean enabled) {
        this.m_maxSizeText.setEnabled(enabled);
        this.m_maxAgeText.setEnabled(enabled);
    }

    private void findToolTipText(Control control, String key) {
        try {
            OptionMetadata[] optionMetadataArray = this.m_flightRecorderService.getAvailableRecordingOptions();
            int n = optionMetadataArray.length;
            int n2 = 0;
            while (n2 < n) {
                OptionMetadata option = optionMetadataArray[n2];
                if (option.getKey().equals(key)) {
                    control.setToolTipText(option.getDescription());
                    return;
                }
                ++n2;
            }
        }
        catch (FlightRecorderException flightRecorderException) {
            // empty catch block
        }
    }

    private boolean showSaveRecordingTemplate() {
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.getShell(), (IWizardPage)new SaveWizardDialog(this.m_templateRepository));
        dialog.setWidthConstaint(600, 800);
        dialog.setHeightConstraint(400, 600);
        if (dialog.open() == 0) {
            this.m_templateRepository.saveTemplate(this.getTemplate());
            this.refresh();
            return true;
        }
        return false;
    }

    private void openAdvanced() {
        RecordingTemplate template = this.getTemplate();
        if (!this.m_templateRepository.isUnsaved(template)) {
            template = template.createClone();
            template.setName(NLS.bind((String)Messages.RECORDING_TEMPLATE_COPY_NAME, (Object)template.getName()));
            template.setModifiable(true);
            if (this.showAdvancedDialog(template)) {
                this.m_templateRepository.add(template, false);
                this.m_templateRepository.setActive(template);
                this.refresh();
            }
        } else if (this.showAdvancedDialog(template)) {
            this.refresh();
        }
    }

    private boolean showAdvancedDialog(RecordingTemplate template) {
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.getShell(), (IWizardPage)new AdvancedWizardPage(template, this.m_flightRecorderService));
        dialog.setWidthConstaint(600, 800);
        dialog.setHeightConstraint(400, 600);
        return dialog.open() == 0;
    }
}

