/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.ui.fields.FilterMatcher;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContainer;
import java.util.HashSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class RecordingTemplateViewerFilter
extends ViewerFilter {
    private String m_filterString;
    private boolean m_showOnlyTemplate;
    private FilterMatcher m_filterMatcher = FilterMatcher.getInstance();
    private HashSet<PathElement> m_filterCache;

    RecordingTemplateViewerFilter() {
    }

    public void update(String filterString, boolean showOnlyTemplate) {
        this.m_filterString = filterString;
        this.m_showOnlyTemplate = showOnlyTemplate;
        if (this.filterIsEmpty()) {
            return;
        }
        this.m_filterString = FilterMatcher.autoAddKleene((String)this.m_filterString, (FilterMatcher.Where)FilterMatcher.Where.BEFORE_AND_AFTER);
        this.m_filterCache = new HashSet();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.matchAgainstFilter((PathElement)element);
    }

    private boolean matchAgainstFilter(PathElement element) {
        if (this.m_showOnlyTemplate && element.getType() == PathElement.PathElementType.ONLY_ON_SERVER) {
            return false;
        }
        if (this.noFilterOrInFilterCache(element)) {
            return true;
        }
        return this.matchesFilter(element);
    }

    private boolean noFilterOrInFilterCache(PathElement element) {
        return this.filterIsEmpty() || this.m_filterCache.contains(element);
    }

    private boolean matchesFilter(PathElement element) {
        if (this.matchFilterString(element)) {
            this.m_filterCache.add(element);
            return true;
        }
        return this.parentMatchesFilter(element) || this.childrenMatchesFilter(element);
    }

    private boolean matchFilterString(PathElement element) {
        return this.m_filterMatcher.matchCaseUnsensitive(element.getPathDescriptor().getName(), this.m_filterString);
    }

    private boolean parentMatchesFilter(PathElement element) {
        PathElement parent = element.getParent();
        while (parent.getParent() != null) {
            if (this.filterIsEmpty() || this.matchFilterString(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean childrenMatchesFilter(PathElement element) {
        if (element instanceof PropertyContainer) {
            for (PathElement child : ((PropertyContainer)element).getChildren()) {
                if (!this.matchAgainstFilter(child)) continue;
                this.m_filterCache.add(element);
                return true;
            }
        }
        return false;
    }

    private boolean filterIsEmpty() {
        return this.m_filterString.length() == 0;
    }
}

