/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmEventProperties;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingOption;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.Property;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContainer;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContentBuilder;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContentProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingTemplateViewerComparator;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingTemplateViewerFilter;
import com.jrockit.mc.rjmx.core.internal.TimeRangeToolkit;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.flr.Option;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordingTemplatePart {
    private static final int PROPERYY_EDITORS_MIN_WIDTH = 200;
    private static final int PROPERTY_EDITORS_MIN_HEIGHT = 150;
    private static final String DURATION_CONTENT_TYPE = "duration";
    private static final String BOOLEAN_CONTENT_TYPE = "boolean";
    private WizardPage m_wizardPage;
    private IFlightRecorderService m_flightRecorderService;
    private JvmEventProperties m_serverEventProperties;
    private RecordingTemplate m_recordingTemplate;
    private TreeViewer m_propertyTreeViewer;
    private PathElement m_selectedElement;
    private Composite m_propertyEditorsContainer;
    private boolean m_hasTemplateCheckbox;
    private boolean m_editable;
    private Button m_onlyTemplateCheckBox;
    private Text m_filterText;
    private RecordingTemplateViewerFilter m_filter;

    public RecordingTemplatePart(WizardPage wizardPage, IFlightRecorderService flightRecorderService, RecordingTemplate recordingTemplate, boolean hasTemplateCheckbox) {
        this.m_wizardPage = wizardPage;
        this.m_flightRecorderService = flightRecorderService;
        this.m_recordingTemplate = recordingTemplate;
        this.m_hasTemplateCheckbox = hasTemplateCheckbox;
        this.m_editable = true;
    }

    private JvmEventProperties getServerEventProperties() {
        if (this.m_serverEventProperties == null) {
            this.m_serverEventProperties = new JvmEventProperties(this.m_flightRecorderService);
        }
        return this.m_serverEventProperties;
    }

    public void setInput(RecordingTemplate recordingTemplate) {
        this.m_recordingTemplate = recordingTemplate;
        this.updateInput();
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, false, false);
        Label filterLabel = this.createFilterDetailsLabel(container);
        filterLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Text filterText = this.createFilterDetailsText(container);
        filterText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        TreeViewer viewer = this.createTreeViewer(container);
        gd3.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, true);
        Composite details = this.createScrollablePropertyEditorsContainer(container);
        details.setLayoutData((Object)gd4);
        if (this.m_hasTemplateCheckbox) {
            GridData gd5 = new GridData(4, 4, true, false);
            Button showOnlyTemplateCheckBox = this.createShowOnlyTemplateCheckBox(container);
            gd5.horizontalSpan = 3;
            showOnlyTemplateCheckBox.setLayoutData((Object)gd5);
        }
        this.hookListeners();
        this.updateInput();
        return container;
    }

    private Label createFilterDetailsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILTER_TEXT);
        return label;
    }

    private Text createFilterDetailsText(Composite parent) {
        this.m_filterText = new Text(parent, 2048);
        this.updateFilter();
        return this.m_filterText;
    }

    private void updateFilter() {
        if (this.m_filter != null) {
            String filterText = this.m_filterText != null ? this.m_filterText.getText() : "";
            boolean onlyTemplate = this.m_onlyTemplateCheckBox != null ? this.m_onlyTemplateCheckBox.getSelection() : false;
            this.m_filter.update(filterText, onlyTemplate);
        }
    }

    private Button createShowOnlyTemplateCheckBox(Composite parent) {
        this.m_onlyTemplateCheckBox = new Button(parent, 32);
        this.m_onlyTemplateCheckBox.setText(Messages.BUTTON_ONLY_SHOW_TEMPLATE_SETTINGS_TEXT);
        this.m_onlyTemplateCheckBox.setSelection(true);
        this.updateFilter();
        return this.m_onlyTemplateCheckBox;
    }

    private Composite createScrollablePropertyEditorsContainer(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2304);
        Composite wrapped = this.createPropertyEditorsContainer((Composite)sc);
        sc.setContent((Control)wrapped);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(150);
        sc.setMinWidth(200);
        return sc;
    }

    private Composite createPropertyEditorsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.m_propertyEditorsContainer = container;
        return container;
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.m_propertyTreeViewer = new TreeViewer(parent, 2304);
        this.m_propertyTreeViewer.setAutoExpandLevel(2);
        this.m_propertyTreeViewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider(this.m_propertyTreeViewer.getTree().getDisplay()));
        this.m_propertyTreeViewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.m_filter = new RecordingTemplateViewerFilter();
        this.updateFilter();
        this.m_propertyTreeViewer.addFilter((ViewerFilter)this.m_filter);
        this.m_propertyTreeViewer.setComparator((ViewerComparator)new RecordingTemplateViewerComparator());
        return this.m_propertyTreeViewer;
    }

    private void hookListeners() {
        this.hookFilterListener();
        if (this.m_hasTemplateCheckbox) {
            this.hookOnlyTemplateListener();
        }
        this.hookTreeSelectionListener();
    }

    private void hookFilterListener() {
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingTemplatePart.this.refreshTreeWithFilter();
            }
        });
    }

    private void hookOnlyTemplateListener() {
        this.m_onlyTemplateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingTemplatePart.this.refreshTreeWithFilter();
            }
        });
    }

    private void refreshTreeWithFilter() {
        this.updateFilter();
        this.m_propertyTreeViewer.getTree().setRedraw(false);
        this.m_propertyTreeViewer.refresh();
        if (this.m_filterText.getText().length() == 0) {
            this.m_propertyTreeViewer.collapseAll();
        } else {
            this.m_propertyTreeViewer.expandAll();
        }
        this.m_propertyTreeViewer.getTree().setRedraw(true);
        this.m_propertyTreeViewer.getTree().redraw();
    }

    private void hookTreeSelectionListener() {
        this.m_propertyTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RecordingTemplatePart.this.updateSelected(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    private void updateInput() {
        Object[] expanded = this.m_propertyTreeViewer.getExpandedElements();
        ISelection currentSelection = this.m_propertyTreeViewer.getSelection();
        this.m_propertyTreeViewer.getTree().setRedraw(false);
        this.m_propertyTreeViewer.setInput((Object)new RecordingTemplateModel(this.m_recordingTemplate, this.getServerEventProperties()));
        if (this.m_filterText.getText().length() > 0) {
            this.m_propertyTreeViewer.expandAll();
        } else {
            this.m_propertyTreeViewer.setExpandedElements(expanded);
        }
        if (currentSelection != null) {
            this.m_propertyTreeViewer.setSelection(currentSelection, true);
        }
        this.m_propertyTreeViewer.getTree().setRedraw(true);
        this.m_propertyTreeViewer.getTree().redraw();
    }

    private void updateSelected(Object object) {
        if (object == this.m_selectedElement) {
            return;
        }
        this.m_selectedElement = object instanceof PathElement ? (PathElement)object : null;
        this.updatePropertyEditors();
    }

    private void updatePropertyEditors() {
        Control[] controlArray = this.m_propertyEditorsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Map<String, Set<Property>> properties = this.findProperties();
        Object[] propertyKeys = properties.keySet().toArray(new String[0]);
        Arrays.sort(propertyKeys);
        Object[] objectArray = propertyKeys;
        int n3 = propertyKeys.length;
        int n4 = 0;
        while (n4 < n3) {
            Object propertyKey = objectArray[n4];
            GridData gd1 = new GridData(16384, 0x1000000, false, false);
            Label propertyKeyLabel = new Label(this.m_propertyEditorsContainer, 0);
            propertyKeyLabel.setText(this.getLocalizedKey((String)propertyKey));
            propertyKeyLabel.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, false);
            Control propertyControl = this.createPropertyControl(this.m_propertyEditorsContainer, (String)propertyKey, properties.get(propertyKey));
            propertyControl.setLayoutData((Object)gd2);
            ++n4;
        }
        this.m_propertyEditorsContainer.layout(true, true);
    }

    private String getLocalizedKey(String propertyKey) {
        String localizedString = PropertyContentBuilder.LOCALIZED_PROPERTY_NAME.get(propertyKey);
        return localizedString == null ? propertyKey : localizedString;
    }

    private Map<String, Set<Property>> findProperties() {
        HashMap<String, Set<Property>> properties = new HashMap<String, Set<Property>>();
        this.findProperties(this.m_selectedElement, properties);
        return properties;
    }

    private void findProperties(PathElement pathElement, Map<String, Set<Property>> properties) {
        if (pathElement instanceof Property) {
            this.findProperties((Property)pathElement, properties);
        } else if (pathElement instanceof PropertyContainer) {
            this.findProperties((PropertyContainer)pathElement, properties);
        }
    }

    private void findProperties(PropertyContainer folder, Map<String, Set<Property>> properties) {
        for (PathElement child : folder.getChildren()) {
            this.findProperties(child, properties);
        }
    }

    private void findProperties(Property property, Map<String, Set<Property>> properties) {
        if (!this.propertyExists(property)) {
            return;
        }
        Set<Property> propertySet = properties.get(property.getName());
        if (propertySet == null) {
            propertySet = new HashSet<Property>();
            properties.put(property.getName(), propertySet);
        }
        propertySet.add(property);
    }

    private boolean propertyExists(Property property) {
        return this.getServerEventProperties().getProperty(property.getPath()) != null;
    }

    private Control createPropertyControl(Composite parent, String propertyName, Set<Property> properties) {
        CommonValueProperties cvp = this.findCommonValueProperties(properties);
        if (cvp.contentType.equals(BOOLEAN_CONTENT_TYPE)) {
            return this.createBooleanPropertyControl(parent, properties, cvp);
        }
        if (cvp.contentType.equals(DURATION_CONTENT_TYPE)) {
            return this.createDurationPropertyControl(parent, properties, cvp, propertyName.equals("threshold"));
        }
        return null;
    }

    private CommonValueProperties findCommonValueProperties(Set<Property> properties) {
        CommonValueProperties cvp = null;
        for (Property property : properties) {
            if (cvp == null) {
                cvp = this.initCommonValueProperties(property);
                continue;
            }
            this.updateCommonValueProperties(cvp, property);
        }
        return cvp;
    }

    private CommonValueProperties initCommonValueProperties(Property property) {
        Option option = this.getServerEventProperties().getProperty(property.getPath());
        CommonValueProperties cvp = new CommonValueProperties();
        cvp.contentType = option.getMetaData().getContentType();
        cvp.min = option.getMetaData().getMin();
        cvp.max = option.getMetaData().getMax();
        cvp.type = option.getMetaData().getType();
        cvp.value = property.getValue();
        return cvp;
    }

    private void updateCommonValueProperties(CommonValueProperties cvp, Property property) {
        Option option = this.getServerEventProperties().getProperty(property.getPath());
        this.updateCommonContentTypeProperty(cvp, option);
        this.updateCommonTypeProperty(cvp, option);
        this.updateCommonMaxValueProperty(cvp, option);
        this.updateCommonMinValueProperty(cvp, option);
        this.updateCommonValueProperty(cvp, property);
    }

    private void updateCommonContentTypeProperty(CommonValueProperties cvp, Option option) {
        if (cvp.contentType != null && !cvp.contentType.equals(option.getMetaData().getContentType())) {
            cvp.contentType = null;
        }
    }

    private void updateCommonTypeProperty(CommonValueProperties cvp, Option option) {
        if (cvp.type != null && !cvp.type.equals(option.getMetaData().getType())) {
            cvp.type = null;
            cvp.max = null;
            cvp.min = null;
        }
    }

    private void updateCommonMaxValueProperty(CommonValueProperties cvp, Option option) {
        if (cvp.max != null && !cvp.max.equals(option.getMetaData().getMax())) {
            cvp.max = null;
        }
    }

    private void updateCommonMinValueProperty(CommonValueProperties cvp, Option option) {
        if (cvp.min != null && !cvp.min.equals(option.getMetaData().getMin())) {
            cvp.min = null;
        }
    }

    private void updateCommonValueProperty(CommonValueProperties props, Property property) {
        if (props.value != null && !props.value.equals(property.getValue())) {
            props.value = null;
        }
    }

    private Control createBooleanPropertyControl(Composite parent, Set<Property> properties, CommonValueProperties cvp) {
        Button checkbox = new Button(parent, 32);
        if (cvp.value != null) {
            checkbox.setSelection(Boolean.valueOf(cvp.value).booleanValue());
        } else {
            checkbox.setGrayed(true);
            checkbox.setSelection(true);
        }
        checkbox.setEnabled(this.getEditable());
        checkbox.addSelectionListener(this.createSelectionListener(properties, checkbox));
        return checkbox;
    }

    private SelectionListener createSelectionListener(final Set<Property> properties, final Button checkbox) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkbox.getGrayed()) {
                    checkbox.setGrayed(false);
                    checkbox.setSelection(true);
                }
                RecordingTemplatePart.this.updateProperties(properties, Boolean.toString(checkbox.getSelection()));
            }
        };
    }

    private Control createDurationPropertyControl(Composite parent, Set<Property> properties, CommonValueProperties cvp, boolean inNanos) {
        Text text = new Text(parent, 2048);
        if (cvp.value != null) {
            if (inNanos) {
                text.setText(TimeRangeToolkit.convertNanosToNormalizedString((long)Long.valueOf(cvp.value)));
            } else {
                text.setText(TimeRangeToolkit.convertMillisToNormalizedString((long)Long.valueOf(cvp.value)));
            }
        }
        text.setEditable(this.getEditable());
        text.addModifyListener(this.createModifyListener(properties, text, inNanos));
        return text;
    }

    private ModifyListener createModifyListener(final Set<Property> properties, final Text text, boolean inNanos) {
        if (inNanos) {
            return new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        RecordingTemplatePart.this.updateProperties(properties, Long.toString(TimeRangeToolkit.parseNanos((String)text.getText())));
                        RecordingTemplatePart.this.clearErrorMessage();
                    }
                    catch (Exception e1) {
                        RecordingTemplatePart.this.setErrorMessage(e1.getMessage());
                    }
                }
            };
        }
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    RecordingTemplatePart.this.updateProperties(properties, Long.toString(TimeRangeToolkit.parseMillis((String)text.getText())));
                    RecordingTemplatePart.this.clearErrorMessage();
                }
                catch (Exception e1) {
                    RecordingTemplatePart.this.setErrorMessage(e1.getMessage());
                }
            }
        };
    }

    private void setErrorMessage(String errorMessage) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(errorMessage, 3);
        }
    }

    private void clearErrorMessage() {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(null);
        }
    }

    private void updateProperties(Set<Property> properties, String newValue) {
        for (Property property : properties) {
            property.setValue(newValue);
            RecordingOption ro = this.m_recordingTemplate.findOption(property.getPath());
            if (ro == null) {
                ro = new RecordingOption();
                ro.setFullKeyPath(property.getPath());
            }
            ro.setValue(newValue);
            this.m_recordingTemplate.setOption(ro);
        }
        this.m_propertyTreeViewer.refresh();
    }

    private static class CommonValueProperties {
        private Class<?> type;
        private Object min;
        private Object max;
        private String contentType;
        private String value;

        private CommonValueProperties() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + '[' + this.type + ',' + this.max + ',' + this.min + ',' + this.contentType + ',' + this.value + ']';
        }
    }
}

