/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.misc.MCColor;
import com.jrockit.mc.core.misc.ui.ColorProvider;
import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.Property;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContainer;
import com.jrockit.mc.rjmx.core.internal.TimeRangeToolkit;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

final class PropertyLabelProvider
extends LabelProvider
implements IFontProvider {
    private ColorProvider m_colorProvider;

    public PropertyLabelProvider(Display display) {
        this.m_colorProvider = new ColorProvider(display, 14);
    }

    public void dispose() {
        this.m_colorProvider.dispose();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof PropertyContainer) {
            return this.getContainerImage((PropertyContainer)element);
        }
        assert (element instanceof Property);
        return CorePlugin.getDefault().getImage("property_obj.gif");
    }

    private Image getContainerImage(PropertyContainer propertyContainer) {
        switch (propertyContainer.getContainerType()) {
            case EVENT: {
                return this.getEventImage(propertyContainer);
            }
            case FOLDER: {
                return CorePlugin.getDefault().getImage("fldr_obj.gif");
            }
        }
        assert (false);
        return null;
    }

    private Image getEventImage(PropertyContainer folder) {
        PathDescriptor pd = folder.getPathDescriptor();
        Image i = this.m_colorProvider.getImage((Object)pd);
        if (i == null) {
            this.m_colorProvider.registerColor((Object)pd, new MCColor(pd.getColor()));
            i = this.m_colorProvider.getImage((Object)pd);
        }
        return i;
    }

    public String getText(Object element) {
        if (element instanceof PathElement) {
            String text = ((PathElement)element).getPathDescriptor().getName();
            if (element instanceof Property) {
                Property property = (Property)element;
                text = property.getName().equals("threshold") ? String.valueOf(text) + '=' + TimeRangeToolkit.convertNanosToNormalizedString((long)Long.valueOf(property.getValue())) : (property.getName().equals("requestPeriod") ? String.valueOf(text) + '=' + TimeRangeToolkit.convertMillisToNormalizedString((long)Long.valueOf(property.getValue())) : String.valueOf(text) + '=' + property.getValue());
            }
            return text;
        }
        assert (false);
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof PathElement) {
            return this.getFont((PathElement)element);
        }
        return null;
    }

    private Font getFont(PathElement pathElement) {
        switch (pathElement.getType()) {
            case ONLY_IN_TEMPLATE: {
                return this.getPropertyDoesNotExistFont();
            }
            case BOTH: {
                return this.getPropertyPartOfTemplateFont();
            }
            case ONLY_ON_SERVER: {
                return this.getNormalFont();
            }
        }
        throw new IllegalArgumentException("Illegal type " + (Object)((Object)pathElement.getType()) + '!');
    }

    private Font getPropertyDoesNotExistFont() {
        return CorePlugin.getDefault().getFontColorToolkit().getBoldItalicTableFont();
    }

    private Font getPropertyPartOfTemplateFont() {
        return CorePlugin.getDefault().getFontColorToolkit().getBoldTableFont();
    }

    private Font getNormalFont() {
        return CorePlugin.getDefault().getFontColorToolkit().getNormalTableFont();
    }
}

