/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.api.PathDescriptorRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmEventProperties;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.Property;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContainer;
import com.jrockit.mc.rjmx.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.flr.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyContentBuilder {
    public static final Map<String, String> LOCALIZED_PROPERTY_NAME = new HashMap<String, String>();
    private static final String PATH_SPLIT_REGEX = "\\.";
    private final RecordingTemplate m_recordingTemplate;
    private final JvmEventProperties m_serverEventProperties;
    private final PathDescriptorRepository m_repository;

    static {
        LOCALIZED_PROPERTY_NAME.put("enabled", Messages.LABEL_EVENT_ENABLED);
        LOCALIZED_PROPERTY_NAME.put("requestPeriod", Messages.LABEL_EVENT_REQUEST_PERIOD);
        LOCALIZED_PROPERTY_NAME.put("stacktrace", Messages.LABEL_EVENT_STACKTRACE);
        LOCALIZED_PROPERTY_NAME.put("threshold", Messages.LABEL_EVENT_THRESHOLD);
    }

    private PropertyContentBuilder(RecordingTemplate recordingTemplate, JvmEventProperties serverEventProperties) {
        this.m_recordingTemplate = recordingTemplate;
        this.m_serverEventProperties = serverEventProperties;
        this.m_repository = PathDescriptorRepository.getDefault();
    }

    public static List<PathElement> build(RecordingTemplate recordingTemplate, JvmEventProperties serverEventProperties) {
        return new PropertyContentBuilder(recordingTemplate, serverEventProperties).build();
    }

    public static List<PathElement> build(RecordingTemplateModel model) {
        return PropertyContentBuilder.build(model.getTemplate(), model.getServerProperties());
    }

    private List<PathElement> build() {
        Map<String, String> eventNames = this.createEventNames();
        Properties properties = this.createEventProperties();
        PropertyContainer folder = new PropertyContainer(null, null, null, null);
        this.addEventProperties(properties, folder, eventNames);
        return folder.getChildren();
    }

    private Map<String, String> createEventNames() {
        HashMap<String, String> eventNames = new HashMap<String, String>();
        for (Object property : this.m_serverEventProperties.toProperties().keySet()) {
            int index;
            String propertyName = property.toString();
            String eventName = propertyName.substring(0, index = propertyName.lastIndexOf(46));
            if (eventNames.get(eventName) != null) continue;
            eventNames.put(eventName, this.getEventName(this.m_serverEventProperties.getEventMetaData(propertyName)));
        }
        return eventNames;
    }

    private String getEventName(EventTypeMetadata eventMetaData) {
        Option[] optionArray = eventMetaData.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.getMetaData().getKey().equals("name")) {
                return option.getValue().toString();
            }
            ++n2;
        }
        return null;
    }

    private Properties createEventProperties() {
        Properties properties = this.m_serverEventProperties.toProperties();
        for (Map.Entry<Object, Object> entry : this.m_recordingTemplate.getProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    private void addEventProperties(Properties properties, PropertyContainer folder, Map<String, String> eventNames) {
        for (Object keyObject : properties.keySet()) {
            String key = (String)keyObject;
            String value = properties.getProperty(key);
            this.add(folder, eventNames, key.split(PATH_SPLIT_REGEX), 0, value, this.getType(key));
        }
    }

    private void add(PropertyContainer parent, Map<String, String> eventNames, String[] splittedPath, int index, String value, PathElement.PathElementType type) {
        if (index < splittedPath.length) {
            String name = splittedPath[index];
            String fullPath = this.getFullPath(parent, name);
            if (index + 1 < splittedPath.length) {
                PropertyContainer.PropertyContainerType containerType = PropertyContainer.PropertyContainerType.FOLDER;
                String eventName = null;
                if (index + 2 == splittedPath.length) {
                    eventName = this.getEventName(eventNames, name, fullPath.replace('/', '.'));
                    containerType = PropertyContainer.PropertyContainerType.EVENT;
                }
                PropertyContainer folder = parent.createContainer(containerType, name, this.getPathDescriptor(fullPath, eventName));
                this.add(folder, eventNames, splittedPath, index + 1, value, type);
            } else {
                parent.add(new Property(parent, name, this.getOptionDescriptor(fullPath, name), type, value));
            }
        }
    }

    private String getEventName(Map<String, String> eventNames, String name, String path) {
        String eventName = eventNames.get(path);
        if (eventName != null) {
            name = eventName;
        }
        return name;
    }

    private PathDescriptor getPathDescriptor(String path, String name) {
        return this.m_repository.createPathDescriptor(path, name);
    }

    private String getFullPath(PropertyContainer parent, String name) {
        if (parent.getParent() == null) {
            return name;
        }
        return String.valueOf(parent.getFullPath()) + '/' + name;
    }

    private PathDescriptor getOptionDescriptor(String path, String name) {
        String localizedName = LOCALIZED_PROPERTY_NAME.get(name);
        return this.getPathDescriptor(path, localizedName);
    }

    private PathElement.PathElementType getType(String property) {
        if (this.m_serverEventProperties.getProperty(property) == null) {
            return PathElement.PathElementType.ONLY_IN_TEMPLATE;
        }
        if (this.m_recordingTemplate.findOption(property) == null) {
            return PathElement.PathElementType.ONLY_ON_SERVER;
        }
        return PathElement.PathElementType.BOTH;
    }
}

