/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.Property;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyContainer
extends PathElement {
    private final PropertyContainerType m_containerType;
    private final List<PropertyContainer> m_containers = new ArrayList<PropertyContainer>();
    private final List<Property> m_options = new ArrayList<Property>();

    public PropertyContainer(PathElement parent, PropertyContainerType containerType, String name, PathDescriptor pd) {
        super(parent, name, pd, PathElement.PathElementType.UNKNOWN);
        this.m_containerType = containerType;
    }

    @Override
    public PathElement.PathElementType getType() {
        PathElement.PathElementType currentType = super.getType();
        if (currentType != PathElement.PathElementType.UNKNOWN) {
            return currentType;
        }
        PathElement.PathElementType type = this.getChildrenType();
        this.setType(type);
        return type;
    }

    private PathElement.PathElementType getChildrenType() {
        PathElement.PathElementType childrenType = PathElement.PathElementType.ONLY_ON_SERVER;
        for (PathElement child : this.getChildren()) {
            PathElement.PathElementType childType = child.getType();
            if (childType == PathElement.PathElementType.ONLY_IN_TEMPLATE) {
                return childType;
            }
            if (childrenType == childType) continue;
            childrenType = PathElement.PathElementType.BOTH;
        }
        return childrenType;
    }

    public PropertyContainerType getContainerType() {
        return this.m_containerType;
    }

    public PropertyContainer createContainer(PropertyContainerType containerType, String name, PathDescriptor pd) {
        for (PropertyContainer container : this.m_containers) {
            if (!name.equals(container.getName())) continue;
            return container;
        }
        PropertyContainer p = new PropertyContainer((PathElement)this, containerType, name, pd);
        this.add(p);
        return p;
    }

    public void add(PropertyContainer container) {
        this.m_containers.add(container);
    }

    public void add(Property option) {
        this.m_options.add(option);
    }

    public List<PathElement> getChildren() {
        ArrayList<PathElement> children = new ArrayList<PathElement>();
        children.addAll(this.getContainers());
        children.addAll(this.getOptions());
        return children;
    }

    public List<PropertyContainer> getContainers() {
        return this.m_containers;
    }

    public List<Property> getOptions() {
        return this.m_options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyContainerType {
        FOLDER(0),
        EVENT(1);

        private final int m_category;

        private PropertyContainerType(int category) {
            this.m_category = category;
        }

        public int getCatagory() {
            return this.m_category;
        }
    }
}

