/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.api.PathDescriptor;

abstract class PathElement {
    public static final char PATH_SEPARATOR = '.';
    public static final char PATH_SLASH_SEPARATOR = '/';
    private final String m_name;
    private final PathDescriptor m_pd;
    private final PathElement m_parent;
    private PathElementType m_type;

    protected PathElement(PathElement parent, String name, PathDescriptor pd, PathElementType type) {
        this.m_name = name;
        this.m_pd = pd;
        this.m_parent = parent;
        this.m_type = type;
    }

    public final PathElement getParent() {
        return this.m_parent;
    }

    public final String getName() {
        return this.m_name;
    }

    public final PathDescriptor getPathDescriptor() {
        return this.m_pd;
    }

    protected final void setType(PathElementType type) {
        this.m_type = type;
    }

    public PathElementType getType() {
        return this.m_type;
    }

    public final String getPath() {
        return this.innerGetPath('.');
    }

    private String innerGetPath(char separator) {
        String path = this.getName();
        PathElement pe = this.getParent();
        while (pe != null && pe.getName() != null) {
            path = String.valueOf(pe.getName()) + separator + path;
            pe = pe.getParent();
        }
        return path;
    }

    public final String getFullPath() {
        return this.innerGetPath('/');
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathElement) {
            return this.getPath().equals(((PathElement)obj).getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PathElementType {
        UNKNOWN,
        BOTH,
        ONLY_IN_TEMPLATE,
        ONLY_ON_SERVER;

    }
}

