/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.wizards.ExportToFileWizardPage;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.JvmEventProperties;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyContentProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.PropertyLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingTemplateViewerComparator;
import java.io.File;
import java.util.Collection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRTExportWizardPage
extends ExportToFileWizardPage
implements IPerformFinishable {
    private final RecordingTemplate m_recordingTemplate;
    private final JvmEventProperties m_serverProperties;
    private File m_exportFile;
    private Collection<PathElement> m_exportedItems;

    public JRTExportWizardPage(RecordingTemplate recordingTemplate, JvmEventProperties serverProperties) {
        super("exportTemplateSettingsToFile", "jrt");
        this.setSelectAllAtStart(true);
        this.m_recordingTemplate = recordingTemplate;
        this.m_serverProperties = serverProperties;
    }

    protected void initializeViewer(TreeViewer viewer) {
        this.setTitle(Messages.EXPORT_FILE_TEMPLATE_WIZARD_PAGE_TITLE);
        this.setDescription(Messages.EXPORT_FILE_TEMPLATE_WIZARD_PAGE_DESCRIPTION);
        viewer.setAutoExpandLevel(2);
        viewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider(viewer.getTree().getDisplay()));
        viewer.setComparator((ViewerComparator)new RecordingTemplateViewerComparator());
        viewer.setInput((Object)new RecordingTemplateModel(this.m_recordingTemplate, this.m_serverProperties));
    }

    public boolean performFinish() {
        if (this.isExportToFileOk()) {
            this.m_exportFile = this.getFile();
            this.storeFilename();
            this.m_exportedItems = this.getSelectedItems();
            return true;
        }
        return false;
    }

    public File getExportFile() {
        return this.m_exportFile;
    }

    public Collection<PathElement> getExportedItems() {
        return this.m_exportedItems;
    }
}

