/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingTemplatePart;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ImportTemplateWizardPage
extends WizardPage {
    private final IFlightRecorderService m_flightRecorderService;
    private final RecordingTemplatePart m_recordingTemplateViewer;
    private RecordingTemplate m_recordingTemplate;
    private Label m_descriptionLabel;

    public ImportTemplateWizardPage(String pageName, IFlightRecorderService flightRecorderService) {
        super(pageName);
        this.m_flightRecorderService = flightRecorderService;
        this.m_recordingTemplate = new RecordingTemplate();
        this.m_recordingTemplateViewer = new RecordingTemplatePart(this, this.m_flightRecorderService, this.m_recordingTemplate, true);
        this.m_recordingTemplateViewer.setEditable(false);
    }

    public void createControl(Composite parent) {
        this.setTitle(this.getWizardTitle());
        this.setDescription(this.getWizardDescription());
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Control choiceControl = this.createChoiceControl(container);
        choiceControl.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_descriptionLabel = this.createDescriptionLabel(container);
        this.m_descriptionLabel.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        Control serverProperties = this.m_recordingTemplateViewer.createControl(container);
        serverProperties.setLayoutData((Object)gd3);
        this.setControl((Control)container);
        this.hookListeners();
        this.updateView();
    }

    protected abstract String getWizardTitle();

    protected abstract String getWizardDescription();

    protected abstract Control createChoiceControl(Composite var1);

    protected void hookListeners() {
    }

    private Label createDescriptionLabel(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Messages.RECORDING_TEMPLATE_NOT_AVAILABLE_DESCRIPTION0);
        return label;
    }

    protected abstract void updateView();

    protected void updateView(RecordingTemplate rt) {
        if (rt == null) {
            rt = new RecordingTemplate();
        }
        this.m_recordingTemplate = rt;
        this.updateDescriptionLabel();
        this.m_recordingTemplateViewer.setInput(this.m_recordingTemplate);
    }

    private void updateDescriptionLabel() {
        String description = this.m_recordingTemplate.getDescription();
        if (description == null || description.length() == 0) {
            description = Messages.RECORDING_TEMPLATE_NOT_AVAILABLE_DESCRIPTION0;
        }
        this.m_descriptionLabel.setText(description);
        this.m_descriptionLabel.setToolTipText(description);
    }

    protected IFlightRecorderService getFlightRecorderService() {
        return this.m_flightRecorderService;
    }

    public RecordingTemplate getRecordingTemplate() {
        return this.m_recordingTemplate;
    }
}

