/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.ImportExportToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.ImportTemplateWizardPage;
import com.jrockit.mc.rjmx.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportServerTemplateWizardPage
extends ImportTemplateWizardPage {
    private Map<String, RecordingTemplate> m_serverTemplates;
    private Combo m_templateCombo;

    public ImportServerTemplateWizardPage(IFlightRecorderService flightRecorderService) {
        super("importServerTemplateWizard", flightRecorderService);
    }

    @Override
    protected String getWizardTitle() {
        return Messages.IMPORT_SERVER_TEMPLATE_WIZARD_PAGE_TITLE;
    }

    @Override
    protected String getWizardDescription() {
        return Messages.IMPORT_SERVER_TEMPLATE_WIZARD_PAGE_DESCRIPTION;
    }

    @Override
    protected Control createChoiceControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, false, false);
        Label fileLabel = this.createServerTemplateLabel(container);
        fileLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Control choice = this.createTemplateChoice(container);
        choice.setLayoutData((Object)gd2);
        return container;
    }

    private Label createServerTemplateLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_SERVER_TEMPLATE);
        return label;
    }

    protected Control createTemplateChoice(Composite parent) {
        this.m_templateCombo = new Combo(parent, 12);
        this.m_templateCombo.setVisibleItemCount(20);
        this.m_serverTemplates = this.readTemplates();
        this.setTemplateComboItems(this.m_templateCombo, this.m_serverTemplates);
        return this.m_templateCombo;
    }

    private Map<String, RecordingTemplate> readTemplates() {
        HashMap<String, RecordingTemplate> serverTemplates = new HashMap<String, RecordingTemplate>();
        try {
            for (RecordingTemplate template : ImportExportToolkit.importServerTemplates(this.getFlightRecorderService())) {
                serverTemplates.put(template.getName(), template);
            }
        }
        catch (FlightRecorderException e) {
            DialogToolkit.showExceptionDialogAsync((Display)this.getControl().getDisplay(), (String)Messages.IMPORT_SERVER_TEMPLATE_WIZARD_PAGE_PROBLEM_IMPORTING_SERVER_TEMPLATE_ERROR_MSG, (Throwable)e);
        }
        return serverTemplates;
    }

    private void setTemplateComboItems(Combo templateCombo, Map<String, RecordingTemplate> serverTemplates) {
        Object[] templateNames = serverTemplates.keySet().toArray(new String[serverTemplates.size()]);
        Arrays.sort(templateNames);
        templateCombo.setItems((String[])templateNames);
    }

    @Override
    protected void hookListeners() {
        this.m_templateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportServerTemplateWizardPage.this.updateView();
            }
        });
        if (this.m_serverTemplates.size() > 0) {
            this.m_templateCombo.select(0);
        }
    }

    @Override
    protected void updateView() {
        this.updateView(this.m_serverTemplates.get(this.m_templateCombo.getText()));
    }
}

