/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.ImportExportToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.ImportTemplateWizardPage;
import com.jrockit.mc.rjmx.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportFileTemplateWizardPage
extends ImportTemplateWizardPage {
    private static final String RECORDING_TEMPLATE_FILE_EXTENSION = "*.jrt";
    private static final String ALL_FILE_EXTENSION = "*";
    private static final String[] FILE_EXTENSIONS = new String[]{"*.jrt", "*"};
    private static final String[] FILE_DESCRIPTIONS = new String[]{NLS.bind((String)Messages.FILE_RECORDING_DESCRIPTION, (Object)"*.jrt"), Messages.FILE_ALL_DESCRIPTION};
    private Text m_filenameText;
    private Button m_browseButton;

    public ImportFileTemplateWizardPage(IFlightRecorderService flightRecorderService) {
        super("importFileTemplateWizard", flightRecorderService);
    }

    protected String getWizardTitle() {
        return Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_TITLE;
    }

    protected String getWizardDescription() {
        return Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_DESCRIPTION;
    }

    protected Control createChoiceControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, false, false);
        Label fileLabel = this.createFileLabel(container);
        fileLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.m_filenameText = this.createFilenameText(container);
        this.m_filenameText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        this.m_browseButton = this.createBrowseButton(container);
        this.m_browseButton.setLayoutData((Object)gd3);
        return container;
    }

    private Label createFileLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILENAME_TEXT);
        return label;
    }

    private Text createFilenameText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setEnabled(false);
        return text;
    }

    private Button createBrowseButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_BROWSE_TEXT);
        return button;
    }

    protected void hookListeners() {
        this.m_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportFileTemplateWizardPage.this.openFileDialog();
            }
        });
    }

    private void openFileDialog() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setFilterExtensions(FILE_EXTENSIONS);
        fileDialog.setFilterNames(FILE_DESCRIPTIONS);
        String filename = fileDialog.open();
        if (filename != null) {
            this.m_filenameText.setText(filename);
            this.updateView();
        }
    }

    protected void updateView() {
        File file = new File(this.m_filenameText.getText());
        if (file.exists() && file.isFile()) {
            try {
                this.updateView(ImportExportToolkit.importFile(file));
            }
            catch (IOException ioe) {
                DialogToolkit.showExceptionDialogAsync((Display)this.getControl().getDisplay(), (String)Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_ERROR_DIALOG_TITLE, (Throwable)ioe);
            }
        } else {
            this.updateView(null);
        }
    }
}

